<?php

namespace Drupal\eca_google;

use Drupal\Core\Form\FormStateInterface;

trait GoogleAuthActionConfigTrait {

  protected function getAuthClientIdDefaultConfig() : array {
    return ['auth_client_id' => ''];
  }

  protected function addGoogleAuthConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['auth_client_id'] = [
      '#type' => 'select',
      '#title' => $this->t('Google API Client'),
      '#description' => $this->t('Select the Google API client to use for authentication.'),
      '#options' => $this->googleApiService->getClientOptions(),
      '#default_value' => $this->configuration['auth_client_id'],
      '#required' => TRUE,
      '#empty_option' => $this->t('- Select a Google API client -'),
    ];
    return $form;
  }

  protected function validateApiClientId(array $form, FormStateInterface $form_state) : void {
    $auth_client_id = $form_state->getValue('auth_client_id');
    if (!empty($auth_client_id) && !str_contains($auth_client_id, ':')) {
      $form_state->setErrorByName('auth_client_id', $this->t('Auth Client ID must be in format "auth_type:client_id" (e.g., "service_account:my_client").'));
      return;
    }

    // Extract auth type and client ID for validation.
    if (!empty($auth_client_id)) {
      [$auth_type, $client_id] = explode(':', $auth_client_id, 2);

      if (!in_array($auth_type, ['api_client', 'service_account'])) {
        $form_state->setErrorByName('auth_client_id', $this->t('Auth type must be "oauth" or "service_account".'));
        return;
      }
    }
  }

}
