# ECA: Google

This module allows you to integrate Google services with your Drupal site
using ECA's visual workflow builder. Create workflows that respond to events
on your site by interacting with Google services, or trigger Drupal actions
based on changes in your Google data.

## Features

#### Current Google Services Supported:
- **Google Sheets** - Read, write, query, and manage spreadsheet data
- **Google Meet** - Video conferencing automation

#### Planned Google Services:
- **Google Calendar** - Event and scheduling automation

## Installation

### Install API modules
For all services connected with this suite of modules, you will need to install the
[Google API PHP Client module](https://www.drupal.org/project/google_api_client)
and the included ECA: Google module.

### Configure Google Authentication
After installing the API modules, you must configure your Google authentication. This
module supports API key and Service Account methods for authentication.  Note that
service accounts often don't work as expected for all services. An API key can operate
under a specific user account, which is required for many services, such as Meet and
Calendar, but a service account operates as its own user account and does not have
permissions to other accounts by default.

- Create a project in [Google Cloud Console](https://console.cloud.google.com/), and
  enable the APIs that you want to use with your Drupal site. (e.g. Sheets, Meet, etc.)
- Decide if you will use API key or service account authentication, and create the required
  credentials in your Google Cloud project. If you are using an API key, specify a redirect
  URI of `https://YOUR_DOMAIN/google_api_client/callback`.
- Enter your credentials on your Drupal site. To set up API key authentication,
  go to `/admin/config/services/google_api_client`. To set up Service Account
  authentication, go to `/admin/config/services/google_api_service_client`.
- If you are using an API key, authenticate it to a specific user account by
  going to `/admin/config/services/google_api_client` and choosing the Authenticate option
  from the dropdown button next to the API key.

### Install the service submodules
Once you've completed setup of the credentials, install the service submodules
from this suite that match the APIs you enabled in your project.
(e.g. ECA: Google Sheets, ECA: Google Meet)
