# ECA: Gmail

This module allows you to automate Gmail operations within Drupal ECA workflows.
Send emails, search messages, manage drafts, organize with labels, and configure automated responses using ECA's visual workflow builder.

## Features

### Email Communication:
- **Send Email**: Send professional emails with HTML formatting, attachments, and multiple recipients
- **Create Draft**: Prepare emails for review and approval workflows before sending
- **Send Draft**: Send pre-created drafts with workflow automation and scheduling
- **Auto-Reply Management**: Configure vacation responses and out-of-office messages with scheduling

### Message Organization:
- **Search Messages**: Advanced Gmail search using date ranges, senders, labels, and keywords
- **Get Message**: Retrieve complete email content including headers, body, and attachments
- **Apply Labels**: Organize emails with custom and system labels for automated filing
- **Manage Messages**: Archive, delete, restore, and organize messages in bulk operations

### Label Management:
- **List Labels**: Access all Gmail labels with their internal IDs for workflow automation
- **Get Label by Name**: Find specific labels by display name for dynamic labeling workflows
- **Label Analytics**: Track message counts and organization metrics

### Thread Management:
- **Get Thread**: Access complete email conversations with all messages and participants
- **Conversation Tracking**: Monitor email threads for customer service and communication workflows

### Advanced Capabilities:
- **Flexible Authentication**: Support for both OAuth2 and Service Account methods
- **Gmail Query Syntax**: Advanced search with date ranges, attachment filtering, and keyword matching
- **Token Integration**: Full ECA token replacement for dynamic email workflows
- **Bulk Operations**: Process multiple messages, labels, and threads efficiently
- **Rich Content Support**: HTML emails, multipart messages, and attachment handling

### Available Actions

**Gmail: Send Email**
- Send professional emails with HTML/plain text content and multiple recipients
- Support for CC, BCC, reply-to headers, and thread continuation
- Rich formatting with token replacement for personalized content

**Gmail: Search Messages**
- Advanced search using Gmail's powerful query syntax
- Filter by date ranges, senders, labels, attachments, and keywords
- Pagination support for large result sets with token-based continuation

**Gmail: Get Message**
- Retrieve complete email content with configurable detail levels
- Access headers, body content, attachments, and message metadata
- Support for multiple format options including raw RFC 2822

**Gmail: Create Draft**
- Prepare emails for approval workflows and scheduled sending
- Full formatting support with HTML content and multiple recipients
- Integration with approval processes and content review workflows

**Gmail: Send Draft**
- Send existing drafts with workflow automation
- Perfect for approved content and scheduled email campaigns
- Draft tracking with message ID and thread continuation

**Gmail: Apply Labels**
- Organize emails with system and custom labels
- Bulk labeling operations for automated email filing
- Support for both adding and removing labels from messages

**Gmail: List Labels**
- Access all Gmail labels with internal IDs and message counts
- Essential for dynamic labeling workflows and organization automation
- System and custom label identification with analytics data

**Gmail: Get Label by Name**
- Find label IDs by display names for user-friendly workflows
- Dynamic label resolution for flexible email organization
- Perfect for workflows that use human-readable label names

**Gmail: Manage Messages**
- Archive, delete, restore, and organize messages in bulk
- Automated email housekeeping and retention workflows
- Support for multiple message operations with result tracking

**Gmail: Get Thread**
- Access complete email conversations with all messages
- Conversation tracking for customer service and communication workflows
- Participant identification and message relationship mapping

**Gmail: Set Auto-Reply**
- Configure vacation responses and out-of-office messages
- Scheduled activation with start and end times
- Contact and domain filtering for targeted responses

### Content Integration
Seamless integration with Drupal content workflows:
- **Email Content**: Rich HTML emails with token replacement for personalized messaging
- **Message Data**: Complete email information for content analysis and customer service
- **Token System**: All extracted data available as ECA tokens for workflow automation
- **Attachment Handling**: Support for file attachments and content processing

## Use Cases

**Customer Communication:**
- Send automated order confirmations and status updates
- Process customer inquiries and support ticket responses  
- Configure out-of-office messages and vacation responders
- Archive and organize customer correspondence automatically

**Content Management:**
- Send newsletter and marketing campaigns with personalized content
- Process subscription confirmations and user notifications
- Automate content approval workflows with draft management
- Monitor email engagement and delivery metrics

**Business Automation:**
- Automatically file emails based on sender, subject, or content
- Process invoice and order emails with label-based organization
- Send scheduled reports and automated notifications
- Manage email retention with automated archiving and deletion

**Workflow Integration:**
- Trigger ECA workflows based on incoming email content
- Send notifications when specific emails are received or processed
- Integrate email data with Drupal content and user management
- Process attachments and email content for data extraction

**Team Collaboration:**
- Manage shared inbox organization with automated labeling
- Process team notifications and internal communications
- Configure vacation coverage and auto-response workflows
- Track email threads and conversation history

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication and datetime formatting  
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Gmail API enabled
- Either OAuth2 credentials or Service Account credentials
- Appropriate Gmail API scopes based on required functionality

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with Gmail API scopes
- Access to user's personal Gmail account for full functionality
- Suitable for personal email automation and individual workflows

**Service Account Authentication:**
- Server-to-server authentication for domain-wide access
- Ideal for organization-wide email automation (G Workspace)
- Requires domain administrator setup for user impersonation

**Scope Configuration:**
Different Gmail operations require different API scopes. The module supports read-only, compose, modify, and full access patterns based on your workflow needs.

## Important Notes

**API Limitations:**
Gmail API has daily quota limits - monitor usage for high-volume email operations.

**Search Functionality:**
For Gmail search to work properly, avoid using the `gmail.metadata` scope as it conflicts with query-based searching.

**Authentication Requirements:**
Some operations like sending emails require higher-level scopes than read-only access.