# ECA: Google Calendar

This module allows you to automate Google Calendar operations within Drupal ECA models.
Create, update, delete, and manage calendar events using ECA's visual workflow builder.

## Features

### Complete Event Management:
- **Create Events**: Schedule new events with full metadata support
- **Update Events**: Modify existing events including times, attendees, and reminders
- **Delete Events**: Remove events programmatically
- **Get Events**: Retrieve detailed event information
- **List Events**: Query events with filtering and date ranges

### Calendar Management:
- **List Calendars**: Discover accessible calendars with filtering options
- **Create Calendars**: Add new secondary calendars programmatically
- **Update Calendars**: Modify calendar properties and settings
- **Delete Calendars**: Remove secondary calendars (primary calendar protected)

### Access Control Management:
- **Add Calendar Access**: Grant permissions to users, groups, or domains
- **Remove Calendar Access**: Revoke specific access permissions
- **Update Calendar Access**: Modify existing permission roles
- **List Calendar Access**: Audit current access permissions

### Advanced Capabilities:
- **All-Day Events**: Automatic detection and proper formatting
- **Timezone Support**: Full timezone handling for global scheduling
- **Attendee Management**: Email invitations with response tracking
- **Reminder Configuration**: Popup and email reminders with custom timing
- **Video Conference Integration**: Native Google Meet creation or external platform URLs (Zoom, Teams, etc.)
- **Free/Busy Checking**: Availability queries across multiple calendars
- **Dual Authentication**: Support for both OAuth2 and Service Account methods

### Available Actions

**Google Calendar: Create Event**
- Schedule new events with complete metadata
- Support for all-day events, timezones, attendees, and reminders
- Video conference options: Native Google Meet creation or external platform URLs

**Google Calendar: Update Event**
- Modify existing events including clearing fields with empty tokens
- Add or replace video conferences (Google Meet or external platforms)
- Partial updates preserve existing data

**Google Calendar: Delete Event**
- Remove events by event ID

**Google Calendar: Get Event**
- Retrieve detailed event information including attendee responses

**Google Calendar: List Events**
- Query events with date ranges, search terms, and result limits
- Support for expanding recurring events

**Google Calendar: List Calendars**
- Discover accessible calendars with role-based filtering
- Filter by hidden/deleted status and pagination support

**Google Calendar: Check Free/Busy**
- Multi-calendar availability checking for scheduling conflicts

**Google Calendar: Create Calendar**
- Add new secondary calendars with custom settings

**Google Calendar: Update Calendar**
- Modify calendar properties like name, description, and timezone

**Google Calendar: Delete Calendar**
- Remove secondary calendars (primary calendar protected)

**Google Calendar: Add Access**
- Grant calendar permissions to users, groups, or domains
- Configurable notification sending

**Google Calendar: Remove Access**
- Revoke specific access permissions by ACL rule ID

**Google Calendar: Update Access**
- Modify existing permission roles and scope
- Support for notification preferences

**Google Calendar: List Access**
- Audit current calendar permissions and access rules


### Video Conference Integration
Flexible video conferencing support:
- **Native Google Meet**: Single-action creation with full calendar integration
- **External Platforms**: Support for Zoom, Microsoft Teams, Webex, and custom URLs

### DateTime Handling
Flexible datetime input support:
- **Token Integration**: Use field tokens like `[entity:field_date_range:start_date]`
- **Multiple Formats**: ISO 8601, natural language, various string formats
- **All-Day Detection**: Automatic recognition of date-only events
- **Timezone Conversion**: Proper handling of timezone specifications

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Calendar API enabled
- Either OAuth2 credentials or Service Account credentials
- Calendar sharing configured for service account access (for Service Account authentication)

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with consent screens
- Access to user's personal calendars
- Suitable for interactive applications

**Service Account Authentication:**
- Server-to-server authentication without user interaction
- Requires calendars to be explicitly shared with service account email
- Ideal for automated workflows and system integration

## Use Cases

**Event Automation:**
- Automatically schedule meetings with video conferences from form submissions
- Support both native Google Meet and external platform integration (Zoom, Teams, etc.)
- Sync Drupal content publishing with calendar events and video conferences

**Calendar Management:**
- Provision department calendars automatically
- Manage event categories with separate calendars
- Archive completed project calendars

**Access Control:**
- Grant calendar access based on user roles
- Automate team calendar sharing
- Audit and manage calendar permissions

**Integration Workflows:**
- Two-way sync between Drupal events and Google Calendar
- Availability checking for resource booking
- Automated reminder systems with meeting links included
