# ECA: Google Docs

This module allows you to automate Google Docs operations within Drupal ECA models.
Create, modify, and manage documents using ECA's visual workflow builder.

## Features

### Complete Document Management:
- **Create Documents**: Generate new documents from scratch or templates
- **Template Processing**: Copy existing documents and replace placeholder variables
- **Content Extraction**: Import document content into ECA tokens for processing
- **Text Insertion**: Add content at specific positions within documents
- **Find and Replace**: Update text patterns throughout documents with advanced matching

### Advanced Capabilities:
- **HTML Formatting Support**: Convert HTML markup to Google Docs formatting
- **Template Variables**: Use placeholder replacement with `{{variable_name}}` syntax
- **Flexible Text Insertion**: Add content at beginning, end, or specific positions
- **Smart Text Matching**: Case sensitivity, whole word, and regex pattern matching
- **Dual Authentication**: Support for both OAuth2 and Service Account methods
- **Rich Token Integration**: Access document data throughout ECA workflows

### Available Actions

**Google Docs: Create Document**
- Generate new documents with custom titles and initial content
- HTML formatting automatically converted to Google Docs styling
- Perfect for automated report generation and content publishing

**Google Docs: Create from Template**
- Copy existing documents and replace placeholder variables with dynamic data
- Ideal for contracts, invoices, and personalized documents
- Template format: `{{client_name}}`, `{{project_date}}`, etc.

**Google Docs: Get Document**
- Import document content and metadata into ECA tokens
- Extract both plain text and HTML-formatted content
- Useful for content analysis and Drupal content import workflows

**Google Docs: Insert Text**
- Add content at beginning, end, or specific positions within documents
- Support for HTML formatting in inserted content
- Great for dynamic content addition and automated updates

**Google Docs: Replace Text**
- Find and replace text patterns throughout documents
- Advanced matching options: case sensitivity, whole words, regex patterns
- HTML formatting support in replacement text
- Perfect for template variable replacement and content standardization

### Document Processing Workflow
Powerful automation capabilities:
- **Mail Merge**: Generate personalized documents from Drupal content
- **Report Generation**: Create professional documents from form submissions
- **Content Publishing**: Export articles and content to standardized document formats
- **Template Automation**: Standardize document creation processes

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Google Docs API enabled
- Google Drive API enabled (only required for create from template operations)
- Either OAuth2 credentials or Service Account credentials
- Documents shared with service account email (for Service Account authentication)

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with consent screens
- Access to user's personal documents
- Suitable for interactive document creation

**Service Account Authentication:**
- Server-to-server authentication without user interaction
- Requires documents to be explicitly shared with service account email
- Ideal for automated workflows and system integration

## Use Cases

**Document Automation:**
- Automatically generate contracts and agreements from form submissions
- Create invoices and quotes with dynamic pricing from commerce data
- Export structured content to professional document formats

**Template Processing:**
- Mail merge functionality for personalized communications
- Generate reports with consistent formatting and branding
- Create certificates and awards with custom data insertion

**Content Management:**
- Import Google Docs content into Drupal for editing and publishing
- Synchronize document updates with Drupal content
- Archive and backup document workflows

**Business Process Integration:**
- Generate meeting agendas from calendar events
- Create project documentation from task management systems
- Automate compliance documentation with audit trails

## Template Format

**Simple Placeholder Replacement:**
```
Template: "Dear {{client_name}}, your payment for {{project_name}} is due on {{due_date}}."
Variables: client_name: John Smith | project_name: Website Redesign | due_date: March 15, 2024
Result: "Dear John Smith, your payment for Website Redesign is due on March 15, 2024."
```

**Using with ECA Tokens:**
```
Variables Configuration:
client_name: [node:field_client_name]
project_date: [node:field_start_date:custom:M j, Y]
total_amount: $[node:field_total_amount]
```
