# ECA: Google Drive

This module allows you to automate Google Drive operations within Drupal ECA models.
Upload, download, organize, and share files using ECA's visual workflow builder.

## Features

### Complete File Management:
- **Upload Files**: Upload from URLs, file fields, or generated content to Google Drive
- **Download Files**: Download files with format conversion for Google Workspace documents
- **File Information**: Retrieve comprehensive metadata including size, dates, and ownership
- **Search Files**: Advanced querying with Google Drive's search syntax
- **File Organization**: Create folders and move files for automated organization

### Sharing and Collaboration:
- **Share Files**: Grant permissions to users, groups, or domains with notification options
- **Permission Management**: Role-based access control (reader, commenter, writer, owner)
- **File Operations**: Copy and move files for template duplication and organization

### Advanced Capabilities:
- **Google Workspace Export**: Convert Sheets to XLSX, Docs to DOCX/PDF, Slides to PPTX
- **Multiple Upload Sources**: Support for URLs, file fields, and dynamically generated content
- **Drupal Integration**: Save downloaded files to Drupal's file system with entity creation
- **Flexible Authentication**: Support for both OAuth2 and Service Account methods
- **Rich Token Integration**: Access file data and results throughout ECA workflows

### Available Actions

**Google Drive: Upload File**
- Upload files from URLs, file fields, or generated content
- Support for various file sources and formats
- Configurable size limits and parent folder organization

**Google Drive: Download File**
- Download files with optional format conversion for Google Workspace documents
- Export Google Sheets to XLSX, Docs to PDF/DOCX, Slides to PPTX
- Save to Drupal file system with automatic file entity creation

**Google Drive: Get File Info**
- Retrieve comprehensive file metadata including size, dates, ownership, and capabilities
- Access sharing status and permissions information
- Perfect for file validation and content workflows

**Google Drive: Search Files**
- Advanced file discovery using Google Drive's query syntax
- Support for filtering by name, type, date, owner, location, and more
- Pagination support for large result sets

**Google Drive: Create Folder**
- Programmatically create folder hierarchies with automatic permission inheritance
- Organize files by date, project, or workflow requirements
- Perfect for automated file organization

**Google Drive: Share File/Folder**
- Grant permissions with configurable roles (reader, commenter, writer, owner)
- Support for user, group, domain, and public sharing
- Optional notification emails with custom messages

**Google Drive: Copy File**
- Duplicate files with new names and locations
- Ideal for template workflows and backup creation
- Cross-folder copying support

**Google Drive: Move File**
- Relocate files between folders for automated organization
- Permission inheritance from new parent folders
- Perfect for workflow-based file management

### File Format Support

**Upload Support:**
- Documents, images, videos, archives, and any file type
- Direct upload from URLs with automatic MIME type detection
- Support for Drupal file fields and generated content

**Download with Conversion:**
- **Google Sheets**: PDF, XLSX, CSV, HTML (Sheets only formats)
- **Google Docs**: PDF, DOCX, HTML, Plain Text (Docs only formats)
- **Google Slides**: PDF, PPTX, Plain Text (Slides only formats)
- **Regular Files**: Download in original format (no conversion)

### Search Query Examples
Powerful file searching with Google Drive syntax:
- `name contains "report"` - Files with "report" in the name
- `mimeType="application/pdf"` - PDF files only
- `createdTime > "2024-01-01"` - Files created after specific date
- `parents in "FOLDER_ID"` - Files in specific folder
- `starred = true` - Starred files
- `"me" in owners` - Files owned by authenticated user

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Google Drive API enabled
- Either OAuth2 credentials or Service Account credentials
- Appropriate Google Drive permissions for target folders and files

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with consent screens
- Access to user's personal Google Drive
- Suitable for interactive file management workflows

**Service Account Authentication:**
- Server-to-server authentication without user interaction
- Requires files/folders to be shared with service account email
- Ideal for automated workflows and system integration

## Use Cases

**Document Management:**
- Automatically upload form submissions and attachments to organized Drive folders
- Download and archive important documents to Drupal's file system
- Convert Google Workspace documents to standard formats for processing

**Content Workflows:**
- Search for and import content from Google Drive for publication
- Generate reports and export them to Google Drive for sharing
- Create template documents and duplicate them for new projects

**File Organization:**
- Automatically organize uploaded files into date-based or project-based folders
- Move files between folders based on workflow stages or approval status
- Create backup copies of important files with automated naming

**Collaboration Management:**
- Automatically share files with team members or clients based on project assignments
- Grant temporary access to external collaborators with notification workflows
- Track file access and sharing patterns for compliance and auditing

**Integration Workflows:**
- Sync Drupal media libraries with Google Drive folders
- Create automated backup workflows for critical business documents
- Generate and distribute reports directly to stakeholder Google Drive folders

## File Size Considerations

**Size Limits:**
- Default limit: 50MB (configurable per action)
- Set to 0 to disable size limits (server constraints apply)
- Consider server timeout and memory limits for large files

**Upload Methods:**
- All uploads use Google Drive's multipart upload for reliability
- Large files may require server configuration adjustments (PHP limits, timeouts)

## Important Notes

**File Conversion:**
Google Workspace document export only works with native Google documents (Sheets, Docs, Slides).
Regular uploaded files (PDFs, Word docs, etc.) cannot be converted and download in their original format.

**Authentication Scope:**
Ensure Google API credentials have appropriate Drive API scopes configured for the intended operations.

**File Permissions:**
When using Service Account authentication, files and folders must be explicitly shared with the service account email address.
