# ECA: Google Meet

This module allows you to automate Google Meet operations within Drupal ECA models.
Create meeting spaces, manage participants, and access recordings using ECA's visual workflow builder.

## Features

### Meeting Space Management:
- **Create Meeting Spaces**: Generate new Google Meet spaces with custom settings
- **Update Meeting Spaces**: Modify existing space configurations and access controls
- **Access Control**: Configure participant permissions and moderation settings

### Conference Data Access:
- **Get Conference Records**: Retrieve detailed information about completed meetings
- **List Conference Records**: Query multiple conference records with filtering
- **Participant Management**: Access participant lists and attendance data
- **Recording Access**: List and retrieve meeting recordings with metadata
- **Transcript Access**: Get meeting transcripts and captions data

### Advanced Capabilities:
- **Automated Meeting Creation**: Generate meeting links programmatically
- **Post-Meeting Analytics**: Access attendance, duration, and engagement data
- **Recording Management**: Automated processing of meeting recordings
- **Dual Authentication**: Support for both OAuth2 and Service Account methods
- **Metadata Extraction**: Rich data about meetings, participants, and content

### Available Actions

**Google Meet: Create Meeting Space**
- Generate new Google Meet spaces with configurable access settings
- Perfect for automated meeting scheduling and event integration

**Google Meet: Update Meeting Space**
- Modify existing meeting space configurations
- Update access controls and moderation settings

**Google Meet: Get Conference Record**
- Retrieve detailed information about specific completed meetings
- Access metadata, duration, and participant summaries

**Google Meet: List Conference Records**
- Query multiple conference records with date ranges and filtering
- Ideal for reporting and analytics workflows

**Google Meet: List Participants**
- Access participant lists from completed meetings
- Track attendance and engagement metrics

**Google Meet: List Recordings**
- Discover available recordings with metadata and download information
- Support for automated recording processing workflows

**Google Meet: List Transcripts**
- Access meeting transcripts and captions data
- Enable automated content analysis and archiving

### Workflow Integration
Flexible integration with ECA workflows:
- **Resource Management**: Track meeting room usage and capacity
- **Follow-up Automation**: Process post-meeting data and recordings

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Google Meet API enabled
- Google Workspace account (Google Meet API requires Workspace for full features)
- Either OAuth2 credentials or Service Account credentials
- Appropriate Google Workspace admin permissions for service accounts

**API Access Requirements:**
- Google Meet API access (may require additional approval from Google)
- Google Workspace Enterprise or Education license for full feature access
- Proper OAuth scopes configured for meeting management

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with appropriate Meet scopes
- Access to user's meeting spaces and records
- Suitable for interactive meeting management

**Service Account Authentication:**
- Server-to-server authentication for automated workflows
- Requires Google Workspace domain delegation
- Ideal for automated meeting creation and data processing

## Use Cases

**Automated Meeting Management:**
- Create meeting spaces from form submissions or content publishing
- Generate meeting links for customer support or sales calls
- Schedule and provision recurring team meetings

**Meeting Analytics:**
- Track attendance patterns and engagement metrics
- Generate reports on meeting usage and effectiveness
- Automate follow-up actions based on meeting participation

**Content Processing:**
- Automatically process and archive meeting recordings
- Extract key information from meeting transcripts
- Integrate meeting content with knowledge management systems

**Workflow Integration:**
- Sync meeting data with CRM systems using ECA tokens
- Connect meeting creation with other automation workflows
- Generate meeting summaries and action items from transcript data

## Important Notes

**Google Workspace Requirement:**
Google Meet API requires a Google Workspace account and may have additional licensing requirements for full functionality.

**Data Privacy:**
Meeting recordings and transcripts contain sensitive data - ensure proper access controls and data handling policies are in place.
