# ECA: Google Sheets

This module allows you to automate Google Sheets operations within Drupal ECA models.
Read, write, query, and manage Google Sheets data using ECA's visual workflow builder.

## Features

### Complete CRUD Operations:
- **Read from Sheets**: Import data into ECA tokens for processing
- **Write to Sheets**: Append new rows with dynamic content
- **Update Sheets**: Modify existing rows by row number or criteria
- **Query Sheets**: Server-side filtering with Google's QUERY function
- **Sheet Management**: Create, clear, and delete sheets programmatically

### Advanced Capabilities:**
- **Server-Side Querying**: Use Google's QUERY syntax for complex data filtering
- **Header Row Processing**: Use column names or skip headers as needed
- **Dual Authentication**: Support for both OAuth2 and Service Account methods
- **Google Sheets Syntax**: Data accessible as `[token:Row1:Col1]` matching spreadsheet
  references

### Available Actions

**Google Sheets: Append to Sheet**
- Add new rows to spreadsheets
- Perfect for form submissions and data collection

**Google Sheets: Read from Sheet**
- Import spreadsheet data into ECA tokens
- Supports header row processing and range selection

**Google Sheets: Query Sheet**
- Server-side filtering using Google's QUERY syntax
- Example: `SELECT * WHERE Col1 > 100 AND Col2 = "Active"`

**Google Sheets: Update Sheet**
- Modify specific rows using row numbers or data from queries
- Support for entire row updates or specific column updates

**Google Sheets: Create Sheet**
- Programmatically add new sheets to existing spreadsheets
- Useful for organizing data by date, category, or project

**Google Sheets: Clear Sheet**
- Remove data while preserving formatting

**Google Sheets: Delete Sheet**
- Remove entire sheets for cleanup operations
- Ideal for temporary data processing workflows

### Token System
Data is accessible using Google Sheets syntax:
- `[DATA_TOKEN_NAME:Row1:Col1]` - First row, first column
- `[DATA_TOKEN_NAME:Row2:Name]` - Second row, "Name" column (when using headers)
- `[QUERY_RESULTS_TOKEN_NAME:Row1:_ROW]` - Original row number from query results

## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with Sheets API enabled
- Either OAuth2 credentials or Service Account credentials
- Spreadsheets shared with service account (for Service Account authentication)
