# ECA: YouTube

This module allows you to automate YouTube Data API operations within Drupal ECA models.
Extract video metadata, access channel information, search content, and retrieve captions using ECA's visual workflow builder.

## Features

### Video Information Access:
- **Get Video Info**: Retrieve comprehensive video metadata including statistics, content details, and status information
- **Search Videos**: Advanced search with filtering by channel, date range, duration, and custom ordering
- **Video Analytics**: Access view counts, like counts, engagement metrics, and technical details

### Channel Management:
- **Get Channel Info**: Access channel metadata, subscriber counts, branding settings, and content details
- **List Channel Videos**: Retrieve videos from specific channels with statistics and content information
- **Channel Analytics**: Monitor subscriber growth, video counts, and channel performance metrics

### Caption and Transcript Access:
- **List Captions**: Discover available caption tracks for any video with language and auto-generation status
- **Get Captions**: Download caption content in multiple formats (SRT, VTT, TTML, or original)
- **Multi-Language Support**: Access captions in different languages and detect auto-generated content

### Advanced Capabilities:
- **Flexible Authentication**: Support for both OAuth2 and Service Account methods
- **Rich Metadata Extraction**: Comprehensive video and channel data with thumbnail URLs
- **Date Range Filtering**: Advanced datetime support with multiple input formats
- **Token Integration**: Full ECA token replacement for dynamic content workflows
- **Content Analytics**: Video duration, definition quality, caption availability, and engagement metrics

### Available Actions

**YouTube: Get Video Info**
- Retrieve comprehensive video metadata by video ID or full YouTube URL
- Configurable data sections: basic info, statistics, content details, and status information
- Access title, description, thumbnails, view/like counts, duration, and technical specifications

**YouTube: Search Videos**
- Advanced video search with keyword queries and channel filtering
- Date range filtering with flexible datetime input formats
- Result ordering by relevance, date, rating, view count, or title
- Duration filtering for short, medium, or long videos
- Comprehensive search results with video metadata

**YouTube: Get Channel Info**
- Access complete channel information including subscriber and video counts
- Retrieve channel branding settings, banner images, and customization details
- Channel statistics, content details, and uploads playlist information
- Support for channel ID or username input formats

**YouTube: List Channel Videos**
- Retrieve videos from specific channels with full metadata
- Configurable data inclusion for statistics and technical details
- Automatic pagination support for large channel libraries
- Integration with channel uploads playlists

**YouTube: List Captions**
- Discover available caption tracks for any video
- Language identification and auto-generation detection
- Caption track metadata including names and status information
- Essential for accessibility and content analysis workflows

**YouTube: Get Captions**
- Download caption content in multiple formats (SRT, VTT, TTML, original)
- Direct caption ID access for specific language tracks
- Full caption text extraction for content analysis
- Requires OAuth2 authentication and video ownership/permissions

### Content Integration
Seamless integration with Drupal content workflows:
- **Thumbnail URLs**: Video and channel thumbnails ready for use with ECA Helper download actions
- **Rich Metadata**: Complete video information for content curation and analysis
- **Token System**: All extracted data available as ECA tokens for workflow automation
-
## Additional Requirements

**Required Drupal Modules:**
- **ECA: Google** (parent module) - Provides shared Google authentication and datetime formatting
- **ECA** - Event Condition Action workflow system
- **Google API Client** - Google service authentication

**Google Requirements:**
- Google Cloud Platform project with YouTube Data API v3 enabled
- Either OAuth2 credentials or Service Account credentials
- For caption access: OAuth2 authentication and video ownership or appropriate permissions

## Authentication Methods

**OAuth2 Authentication:**
- End-user authorization with YouTube Data API scopes
- Access to user's own videos and channels for caption retrieval
- Suitable for interactive applications and personal content management

**Service Account Authentication:**
- Server-to-server authentication for public data access
- Ideal for automated content analysis and public video information extraction
- Limited to publicly available data (no private video access)

**Caption Access Note:**
Caption downloads require OAuth2 authentication and only work for videos you own or have permission to access due to YouTube API restrictions.

## Use Cases

**Content Curation:**
- Automatically extract video metadata for content management systems
- Monitor channel uploads and analyze video performance metrics
- Create curated playlists based on video analytics and engagement

**SEO and Analytics:**
- Track video performance and engagement metrics over time
- Analyze trending content and optimize video strategies
- Monitor competitor channels and industry content trends

**Accessibility Workflows:**
- Extract captions for accessibility compliance and content analysis
- Process video transcripts for searchable content databases
- Create multi-language content workflows using caption data

**Integration Workflows:**
- Sync YouTube content with Drupal-based video galleries
- Automate content workflows based on video upload schedules
- Generate reports and dashboards using video analytics data
- Process video thumbnails and metadata for content displays

**Research and Monitoring:**
- Analyze video content trends and audience engagement patterns
- Monitor brand mentions and content performance across channels
- Extract video data for academic research and content analysis

## Important Notes

**API Limitations:**
YouTube Data API has daily quota limits - monitor usage for high-volume applications.

**Caption Access:**
Caption downloads require video ownership or appropriate permissions and OAuth2 authentication.

