<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\eca\Plugin\DataType\DataTransferObject;
use Drupal\eca_base\Plugin\Action\KeyValueStoreWrite as KeyValueStoreWriteAlias;

/**
 * Action to write value to the key value store.
 *
 * @Action(
 *   id = "eca_helper_keyvaluestore_write",
 *   label = @Translation("ECA Helper: Key value store write"),
 *   description = @Translation("Write a value to the Drupal key value store by
 *   the given key."), eca_version_introduced = "2.0.0"
 * )
 */
class KeyValueStoreWrite extends KeyValueStoreWriteAlias {

  /**
   * {@inheritdoc}
   */
  protected function doStore(string $collection, bool $ifNotExists, string $key, mixed $value): void {
    if ($value instanceof DataTransferObject) {
      $value = $value->getValue();
    }
    parent::doStore($collection, $ifNotExists, $key, $value);
  }

}
