<?php

namespace Drupal\eca_helper\Traits;

use Drupal\Core\Messenger\MessengerTrait;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * The Dumper Trait.
 */
trait DumperTrait {

  use MessengerTrait, StringTranslationTrait;

  /**
   * Dump the data.
   *
   * @param mixed $value
   *   The value.
   */
  public function dump(mixed $value): void {
    if (function_exists('dump')) {
      dump($value);
    }
    else {
      $this->messenger()
        ->addWarning($this->t('The symfony/var-dumper not found. Please install with command "composer require symfony/var-dumper".'));
    }
  }

}
