<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\eca\Attribute\EcaAction;
use Drupal\eca_content\Plugin\Action\NewEntity;

/**
 * Create new File Entity Object.
 */
#[Action(
  id: 'eca_helper_file_entity_create',
  label: new TranslatableMarkup('ECA Helper: File Entity Create')
)]
#[EcaAction(
  description: new TranslatableMarkup('Action create new file entity.')
)]
class FileEntityCreate extends NewEntity {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildConfigurationForm($form, $form_state);
    if (isset($form['type'])) {
      unset($form['type']);
    }
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    parent::submitConfigurationForm($form, $form_state);
    $this->configuration['type'] = 'file file';
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    return AccessResult::allowed();
  }

}
