<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Action\Attribute\Action;
use Drupal\eca\Attribute\EcaAction;

/**
 * Set variable value from preprocess event.
 */
#[Action(
  id: 'eca_helper_form_add_class',
  label: new TranslatableMarkup('ECA Helper: Form add css class'),
  type: 'form'
)]
#[EcaAction(
  description: new TranslatableMarkup('Add form css class.'),
)]
class FormAddClass extends FormFieldSetValue {

  /**
   * {@inheritdoc}
   */
  protected array $hidden = [
    'field_name',
    'key',
    'value_yaml',
    'method',
    'array',
  ];

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'field_name' => '!!form',
      'key' => '#attributes.class',
      'array' => TRUE,
    ] + parent::defaultConfiguration();
  }

}
