<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Action\Attribute\Action;
use Drupal\eca\Attribute\EcaAction;

/**
 * Set variable value from preprocess event.
 */
#[Action(
  id: 'eca_helper_form_attach_library',
  label: new TranslatableMarkup('ECA Helper: Form attach library'),
  type: 'form'
)]
#[EcaAction(
  description: new TranslatableMarkup('Attach library with to a form.'),
)]
class FormAttachLibrary extends FormFieldSetValue {

  /**
   * {@inheritdoc}
   */
  protected array $hidden = [
    'field_name',
    'key',
    'value_yaml',
    'method',
    'array',
  ];

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'field_name' => '!!form',
      'key' => '#attached.library',
      'array' => TRUE,
    ] + parent::defaultConfiguration();
  }

}
