<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Action\Attribute\Action;
use Drupal\eca\Attribute\EcaAction;

/**
 * Set variable value from preprocess event.
 */
#[Action(
  id: 'eca_helper_preprocess_attach_library',
  label: new TranslatableMarkup('ECA Helper: Preprocess attach library')
)]
#[EcaAction(
  description: new TranslatableMarkup('Attach library with preprocess event.')
)]
class PreprocessAttachLibrary extends PreprocessSetValue {

  /**
   * {@inheritdoc}
   */
  protected array $hidden = [
    'key',
    'value_yaml',
    'method',
    'array',
  ];

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'key' => '#attached.library',
      'array' => TRUE,
    ] + parent::defaultConfiguration();
  }

}
