<?php

namespace Drupal\eca_helper\Plugin\Action;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Action\Attribute\Action;
use Drupal\eca\Attribute\EcaAction;

/**
 * Set variable value from preprocess event.
 */
#[Action(
  id: 'eca_helper_preprocess_set_class_value',
  label: new TranslatableMarkup('ECA Helper: Preprocess add css class')
)]
#[EcaAction(
  description: new TranslatableMarkup('Set css class with preprocess event.')
)]
class PreprocessSetClass extends PreprocessSetValue {

  /**
   * {@inheritdoc}
   */
  protected array $hidden = [
    'key',
    'value_yaml',
    'method',
    'array',
  ];

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'key' => 'attributes.class',
      'array' => TRUE,
      'method' => 'append',
    ] + parent::defaultConfiguration();
  }

}
