<?php

namespace Drupal\eca_helper\Plugin\ECA\Event;

use Drupal\eca\Attribute\EcaEvent;
use Drupal\eca\Attribute\Token;
use Drupal\eca\Event\Tag;
use Drupal\eca\Plugin\ECA\Event\EventBase;
use Drupal\eca_helper\Event\FileDownloadEvent;

/**
 * Plugin implementation of the ECA Events for private file download.
 */
#[EcaEvent(id: 'eca_helper_file_download', deriver: FileDownloadECAEventDeriver::class)]
class FileDownloadECAEvent extends EventBase {

  /**
   * {@inheritdoc}
   */
  public static function definitions(): array {
    return [
      'private_file' => [
        'label' => 'ECA Helper: Private File Download',
        'event_name' => FileDownloadEvent::FILE_DOWNLOAD,
        'event_class' => FileDownloadEvent::class,
        'tags' => Tag::WRITE | Tag::READ,
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  #[Token(
    name: 'event',
    description: 'The private file download event. Support [event:uri], [event:file].',
    properties: [
      new Token(name: 'uri', description: 'The file uri.'),
      new Token(name: 'file', description: 'The file object.'),
    ],
  )]
  protected function buildEventData(): array {
    $event = $this->event;
    $data = [];
    if ($event instanceof FileDownloadEvent) {
      $data += [
        'uri' => $event->getUri(),
        'file' => $event->getFile(),
      ];
    }
    $data += parent::buildEventData();
    return $data;
  }

}
