# ECA: HubSpot

This module allows you to automate HubSpot CRM operations within Drupal ECA models.
Manage contacts, companies, deals, leads, tickets, notes, and tasks using ECA's visual workflow builder.

## Features

### Complete CRM Object Management:
- **Contacts**: Create, update, retrieve, delete, and search contact records
- **Companies**: Create, update, retrieve, delete, and search company records
- **Deals**: Create, update, retrieve, delete, and search sales opportunities
- **Leads**: Create, update, retrieve, delete, and search lead records
- **Tickets**: Create, update, retrieve, delete, and search support tickets
- **Notes**: Create, update, retrieve, delete, and search activity notes
- **Tasks**: Create, update, retrieve, delete, and search activity tasks

### Association Management:
- **Associate Objects**: Create relationships between any CRM objects
- **Disassociate Objects**: Remove relationships between CRM objects
- **Get Associations**: Retrieve all associated objects for a given record

### Pipeline Management:
- **List Pipelines**: Query available pipelines for deals, tickets, or leads
- **Get Pipeline**: Retrieve pipeline details including stages and configuration

### Advanced Capabilities:
- **Email/Domain Lookup**: Contact retrieval by email or company by domain
- **Flexible Search**: YAML-based filters with advanced operators for all object types
- **YAML Settings**: Additional properties support for complete API access
- **Token Integration**: Full ECA token support for dynamic values and response data
- **Association Handling**: Create objects with associations in a single action

### Available Actions

**Contact Management:**

**HubSpot: Create Contact**
- Create new contact records with email, name, phone, company, and lifecycle stage
- YAML-based additional properties for custom fields
- Support for setting lifecycle stages: Subscriber, Lead, MQL, SQL, Opportunity, Customer, Evangelist

**HubSpot: Update Contact**
- Modify existing contact properties by contact ID
- Partial updates preserve unspecified fields
- Update lifecycle stage and custom properties

**HubSpot: Get Contact**
- Retrieve contact details by ID or email address
- Automatic email detection for seamless lookups
- Access all contact properties including custom fields

**HubSpot: Delete Contact**
- Archive contacts by ID (soft delete in HubSpot)

**HubSpot: Search Contacts**
- Server-side filtering with multiple operators: EQ, NEQ, LT, LTE, GT, GTE, CONTAINS_TOKEN, IN, NOT_IN
- Sort results by any property
- Configurable result limits (1-100 records)
- YAML filter format for complex queries

**Company Management:**

**HubSpot: Create Company**
- Create new company records with name, domain, industry, and location
- YAML-based additional properties for custom fields

**HubSpot: Update Company**
- Modify existing company properties by company ID

**HubSpot: Get Company**
- Retrieve company details by ID or domain
- Automatic domain detection for domain-based lookups

**HubSpot: Delete Company**
- Archive companies by ID

**HubSpot: Search Companies**
- Server-side filtering with YAML-based query syntax
- Sort and limit results

**Deal Management:**

**HubSpot: Create Deal**
- Create sales opportunities with name, stage, amount, and close date
- Associate with contacts and companies at creation time
- Support for custom deal properties via YAML

**HubSpot: Update Deal**
- Modify deal properties and move through pipeline stages
- Add new associations to existing deals

**HubSpot: Get Deal**
- Retrieve deal details including associations
- Optional association loading for contacts and companies

**HubSpot: Delete Deal**
- Archive deals by ID

**HubSpot: Search Deals**
- Query deals by stage, amount, close date, or custom properties
- YAML-based filters for complex criteria

**Lead Management:**

**HubSpot: Create Lead**
- Create lead records with name, type, and label
- Requires association with at least one contact
- Support for company associations

**HubSpot: Update Lead**
- Modify lead properties and associations

**HubSpot: Get Lead**
- Retrieve lead details with optional associations

**HubSpot: Delete Lead**
- Archive leads by ID

**HubSpot: Search Leads**
- Filter leads by type, name, or custom properties

**Ticket Management:**

**HubSpot: Create Ticket**
- Create support tickets with subject, content, pipeline, stage, and priority
- Associate with contacts, companies, and deals at creation time
- Priority levels: LOW, MEDIUM, HIGH

**HubSpot: Update Ticket**
- Change ticket status, priority, or properties
- Add new associations to existing tickets

**HubSpot: Get Ticket**
- Retrieve ticket details with optional associations

**HubSpot: Delete Ticket**
- Archive tickets by ID

**HubSpot: Search Tickets**
- Query tickets by status, priority, subject, or custom properties

**Engagement Management:**

**HubSpot: Create Note**
- Log activity notes on contacts, companies, deals, or tickets
- HTML content support
- Associate with multiple objects simultaneously

**HubSpot: Update Note**
- Modify note content and associations

**HubSpot: Get Note**
- Retrieve note details

**HubSpot: Delete Note**
- Remove notes by ID

**HubSpot: Search Notes**
- Find notes by content, timestamp, or associations

**HubSpot: Create Task**
- Create follow-up tasks with subject, body, due date, priority, and type
- Task types: TODO, EMAIL, CALL
- Task priorities: NONE, LOW, MEDIUM, HIGH
- Associate with contacts, companies, deals, or tickets
- Support for owner assignment

**HubSpot: Update Task**
- Modify task properties and associations
- Update status, priority, or due date

**HubSpot: Get Task**
- Retrieve task details

**HubSpot: Delete Task**
- Remove tasks by ID

**HubSpot: Search Tasks**
- Query tasks by status, priority, type, or due date

**Association Management:**

**HubSpot: Associate Objects**
- Create relationships between any two CRM objects
- Supports: contact, company, deal, lead, ticket, note, task
- Bidirectional associations handled automatically

**HubSpot: Disassociate Objects**
- Remove relationships between objects

**HubSpot: Get Associations**
- Retrieve all objects associated with a specific record
- Query by association type (e.g., all contacts for a company)

**Pipeline Management:**

**HubSpot: List Pipelines**
- Query pipelines for deals, tickets, or leads
- Returns pipeline stages and metadata

**HubSpot: Get Pipeline**
- Retrieve specific pipeline details by ID

### Search Filter Syntax
All search actions support YAML-based filters with multiple operators:

**Common Operators:**
- `EQ` - Equals
- `NEQ` - Not equals
- `LT` / `LTE` - Less than / Less than or equal
- `GT` / `GTE` - Greater than / Greater than or equal
- `CONTAINS_TOKEN` - Partial match with wildcards (e.g., `*keyword*`)
- `HAS_PROPERTY` - Property has any value
- `NOT_HAS_PROPERTY` - Property is empty
- `IN` - Value in list
- `NOT_IN` - Value not in list

**Example Search Filters:**

**Inline Format (recommended):**
```yaml
- {propertyName: "lifecyclestage", operator: "EQ", value: "lead"}
- {propertyName: "email", operator: "CONTAINS_TOKEN", value: "*@example.com"}
```

**Block Format:**
```yaml
- propertyName: "lifecyclestage"
  operator: "EQ"
  value: "lead"
- propertyName: "createdate"
  operator: "GT"
  value: "2025-01-01"
```

**Multiple Values (IN operator):**
```yaml
- {propertyName: "hs_lead_status", operator: "IN", values: ["NEW", "OPEN", "IN_PROGRESS"]}
```

See the [HubSpot Search API documentation](https://developers.hubspot.com/docs/api/crm/search) for full details.

### YAML Additional Properties
For maximum flexibility, create and update actions support YAML-based additional properties:

**Contact Properties Example:**
```yaml
website: "https://example.com"
jobtitle: "Marketing Director"
phone: "+1-555-123-4567"
lifecyclestage: "marketingqualifiedlead"
hs_lead_status: "NEW"
custom_field_name: "custom value"
```

**Deal Properties Example:**
```yaml
dealname: "Enterprise Contract - Acme Corp"
dealstage: "qualifiedtobuy"
amount: "50000"
closedate: "2025-12-31"
pipeline: "default"
custom_deal_field: "value"
```

**Task Properties Example:**
```yaml
hs_task_subject: "Follow up call"
hs_task_body: "Discuss pricing options"
hs_task_status: "NOT_STARTED"
hs_task_priority: "HIGH"
hs_timestamp: "2025-11-01T14:00:00Z"
hubspot_owner_id: "12345"
```

## Additional Requirements

**Required Drupal Modules:**
- **ECA** - Event Condition Action workflow system
- **HubSpot API** - HubSpot service authentication and API client

**HubSpot Requirements:**
- HubSpot account (Free, Starter, Professional, or Enterprise)
- Private App Access Token or OAuth 2.0 credentials
- API access enabled for your account

**API Configuration:**
Configure your HubSpot API credentials in the HubSpot API module settings at `/admin/config/services/hubspot-api` before using ECA: HubSpot actions.

## Authentication

**Private App (Recommended):**
- Simple token-based authentication
- Configured once in HubSpot API module settings
- All ECA actions use the same credentials automatically
- Suitable for server-to-server automation

**OAuth 2.0:**
- User-based authentication
- Requires authorization flow
- Suitable for user-specific workflows

## Use Cases

**Lead Capture & Nurturing:**
- Automatically create/update contacts from form submissions
- Set lifecycle stages based on form fields or behavior
- Create deals for qualified leads with score thresholds
- Assign follow-up tasks to sales team members

**Support Ticket Automation:**
- Create tickets from support form submissions
- Link tickets to existing contacts or create new ones
- Associate tickets with company records automatically
- Log notes for all customer interactions

**Sales Pipeline Management:**
- Create deals from e-commerce orders or quote requests
- Update deal stages based on order status
- Associate deals with contacts and companies
- Track deal progress with automated tasks and notes

**Customer Onboarding:**
- Update contact lifecycle stages to "Customer" on purchase
- Create onboarding tasks for account managers
- Log onboarding milestones as notes
- Associate new customers with appropriate company records

**Data Synchronization:**
- Sync Drupal user registrations to HubSpot contacts
- Update company records from business directory submissions
- Maintain bidirectional sync with custom field mappings
- Archive deleted Drupal records in HubSpot

**Workflow Integration Examples:**

**Automated Lead Creation:**
1. User submits lead generation form
2. ECA creates or updates HubSpot contact with form data
3. Contact lifecycle stage set based on lead source
4. Deal created for qualified leads (score threshold)
5. Task assigned to sales rep for follow-up
6. Note logged with form submission details

**Support Ticket Workflow:**
1. Support form submitted
2. Search Contacts by email
3. If contact exists: Update last contact date
4. If contact doesn't exist: Create new contact
5. Create ticket linked to contact
6. Search Companies by domain to link company
7. Create note with ticket details

**Sales Deal Pipeline:**
1. E-commerce order placed
2. Get or Create Contact for buyer
3. Get Company by domain (if B2B order)
4. Create Deal with order amount
5. Associate deal with contact and company
6. Update deal stage to "Closed Won"
7. Create task for account manager

**Lead Nurturing Campaign:**
1. Search Contacts by lifecycle stage "Lead"
2. For each contact:
   - Get contact details
   - Check engagement score from custom property
   - If score > threshold: Update lifecycle to "MQL"
   - Create task for marketing team to engage
   - Add note documenting qualification

## Important Notes

**Email and Domain Lookups:**
The Get Contact action automatically detects email addresses and uses HubSpot's email lookup endpoint. Similarly, Get Company detects domain names and searches by domain property.

**Partial Updates:**
When updating objects, only specified properties are changed. Unspecified properties retain their existing values. This allows safe partial updates without retrieving current values first.

**Associations:**
Objects can be associated at creation time by providing comma-separated IDs in association fields. Associations can also be added later using Update actions or the Associate Objects action.

**Search Pagination:**
Search actions return up to 100 results by default. For larger datasets, implement pagination using the `total` count in results.

**Lifecycle Stages:**
Available lifecycle stages for contacts:
- `subscriber` - Subscriber
- `lead` - Lead
- `marketingqualifiedlead` - Marketing Qualified Lead (MQL)
- `salesqualifiedlead` - Sales Qualified Lead (SQL)
- `opportunity` - Opportunity
- `customer` - Customer
- `evangelist` - Evangelist
- `other` - Other

**DateTime Handling:**
Dates can be provided in multiple formats:
- ISO 8601: `2025-12-31T14:00:00Z`
- Unix timestamp (milliseconds): `1735574400000`
- Natural language via tokens: `[node:created:custom:Y-m-d]`

**API Rate Limits:**
HubSpot enforces rate limits on API requests. For high-volume operations, implement appropriate delays or error handling in your workflows.

## Resources

- [HubSpot CRM API Documentation](https://developers.hubspot.com/docs/api/crm/understanding-the-crm)
- [HubSpot Search API](https://developers.hubspot.com/docs/api/crm/search)
- [HubSpot Contact Properties](https://developers.hubspot.com/docs/api/crm/contacts)
- [HubSpot Company Properties](https://developers.hubspot.com/docs/api/crm/companies)
- [HubSpot Deal Properties](https://developers.hubspot.com/docs/api/crm/deals)
- [HubSpot Ticket Properties](https://developers.hubspot.com/docs/api/crm/tickets)
- [HubSpot Associations](https://developers.hubspot.com/docs/api/crm/associations)
