<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot companies.
 */
#[Action(
  id: 'eca_hubspot_search_companies',
  label: new TranslatableMarkup('HubSpot: Search Companies'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find companies by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchCompanies extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'companies';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'companies';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "name", operator: "CONTAINS_TOKEN", value: "*acme*"}<br>- {propertyName: "city", operator: "EQ", value: "Boston"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "name"<br>&nbsp;&nbsp;operator: "CONTAINS_TOKEN"<br>&nbsp;&nbsp;value: "*acme*"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchCompanies($filters, $sort_by, $limit);
  }

}
