<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot contacts.
 */
#[Action(
  id: 'eca_hubspot_search_contacts',
  label: new TranslatableMarkup('HubSpot: Search Contacts'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find contacts by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchContacts extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'contacts';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'contacts';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "lifecyclestage", operator: "EQ", value: "lead"}<br>- {propertyName: "email", operator: "CONTAINS_TOKEN", value: "*@example.com"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "lifecyclestage"<br>&nbsp;&nbsp;operator: "EQ"<br>&nbsp;&nbsp;value: "lead"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchContacts($filters, $sort_by, $limit);
  }

}
