<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot deals.
 */
#[Action(
  id: 'eca_hubspot_search_deals',
  label: new TranslatableMarkup('HubSpot: Search Deals'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find deals by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchDeals extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'deals';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'deals';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "dealstage", operator: "EQ", value: "closedwon"}<br>- {propertyName: "dealname", operator: "CONTAINS_TOKEN", value: "*enterprise*"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "dealstage"<br>&nbsp;&nbsp;operator: "EQ"<br>&nbsp;&nbsp;value: "closedwon"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchDeals($filters, $sort_by, $limit);
  }

}
