<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot leads.
 */
#[Action(
  id: 'eca_hubspot_search_leads',
  label: new TranslatableMarkup('HubSpot: Search Leads'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find leads by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchLeads extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'leads';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'leads';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "hs_lead_type", operator: "EQ", value: "NEW_BUSINESS"}<br>- {propertyName: "hs_lead_name", operator: "CONTAINS_TOKEN", value: "*enterprise*"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "hs_lead_type"<br>&nbsp;&nbsp;operator: "EQ"<br>&nbsp;&nbsp;value: "NEW_BUSINESS"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchLeads($filters, $sort_by, $limit);
  }

}
