<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot notes.
 */
#[Action(
  id: 'eca_hubspot_search_notes',
  label: new TranslatableMarkup('HubSpot: Search Notes'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find notes by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchNotes extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'notes';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'notes';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "hs_note_body", operator: "CONTAINS_TOKEN", value: "*important*"}<br>- {propertyName: "hs_timestamp", operator: "GT", value: "1735689600000"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "hs_note_body"<br>&nbsp;&nbsp;operator: "CONTAINS_TOKEN"<br>&nbsp;&nbsp;value: "*important*"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchNotes($filters, $sort_by, $limit);
  }

}
