<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot tasks.
 */
#[Action(
  id: 'eca_hubspot_search_tasks',
  label: new TranslatableMarkup('HubSpot: Search Tasks'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find tasks by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchTasks extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'tasks';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'tasks';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "hs_task_status", operator: "EQ", value: "NOT_STARTED"}<br>- {propertyName: "hs_task_priority", operator: "IN", values: ["HIGH", "MEDIUM"]}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "hs_task_status"<br>&nbsp;&nbsp;operator: "EQ"<br>&nbsp;&nbsp;value: "NOT_STARTED"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchTasks($filters, $sort_by, $limit);
  }

}
