<?php

declare(strict_types=1);

namespace Drupal\eca_hubspot\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Search HubSpot tickets.
 */
#[Action(
  id: 'eca_hubspot_search_tickets',
  label: new TranslatableMarkup('HubSpot: Search Tickets'),
  category: new TranslatableMarkup('HubSpot'),
  type: 'system',
)]
#[EcaAction(
  description: new TranslatableMarkup('Find tickets by property criteria and filters.'),
  version_introduced: '1.0.0',
)]
final class SearchTickets extends HubSpotSearchActionBase {

  /**
   * {@inheritdoc}
   */
  protected function getObjectType(): string {
    return 'tickets';
  }

  /**
   * {@inheritdoc}
   */
  protected function getObjectLabel(): string {
    return 'tickets';
  }

  /**
   * {@inheritdoc}
   */
  protected function getFilterExample(): string {
    return '- {propertyName: "hs_pipeline_stage", operator: "EQ", value: "1"}<br>- {propertyName: "subject", operator: "CONTAINS_TOKEN", value: "*urgent*"}';
  }

  /**
   * {@inheritdoc}
   */
  protected function getBlockFilterExample(): string {
    return '- propertyName: "hs_pipeline_stage"<br>&nbsp;&nbsp;operator: "EQ"<br>&nbsp;&nbsp;value: "1"';
  }

  /**
   * {@inheritdoc}
   */
  protected function performSearch(array $filters, string $sort_by, int $limit): ?array {
    return $this->hubspotService->searchTickets($filters, $sort_by, $limit);
  }

}
