# ECA Kafka

Send Kafka messages from Drupal using ECA events and custom templates.

## What it does

This module adds a Kafka publisher action to ECA. When events happen in your Drupal site, you can send structured messages to Kafka topics using the Confluent Cloud API v3.

The action can use templates you define through the template manager or send custom messages directly from the action configuration.

## Template System

Any ECA event can use the Kafka action - you don't need to "enable" events to use them.

The "Enable Events" feature is really about template management. It initializes templates for specific events so template managers only see a focused list instead of all 120+ available ECA events.

Once you enable an event for templates, you can create:

- **General templates** - Default message for that event
- **Model-specific templates** - Custom messages based on event context (like node type or user role)

The ECA action finds the right template automatically based on the event context, or you can skip templates and write custom messages directly in the action.

## Configuration

Two permission levels:

- **Administer ECA Kafka** - Full access to connections, testing, and templates
- **Manage ECA Kafka Templates** - Enable events and edit templates only

## Requirements

- ECA module
- Confluent Cloud account with API access
- Key module (for storing API credentials)

## Important Note

This is a proof-of-concept module. It works for testing and development but hasn't been tested for production use. Use at your own risk.

## Installation

1. Install and enable the module
2. Configure your Kafka connection at `/admin/config/workflow/eca/kafka/connection`
3. Test the connection
4. Initialize templates for events you want to manage (optional)
5. Add the "Kafka: Send Message" action to your ECA configurations

## How the Action Works

The Kafka action looks for templates in this order:
1. Model-specific template (if checkbox enabled and context matches)
2. General template (if checkbox enabled)  
3. Custom message from action configuration

This gives you flexibility to use templates when you want consistency, or custom messages when you need specific control.
