<?php

namespace Drupal\eca_metatag\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\eca\Event\TriggerEvent;

/**
 * Implements metatag hooks for the eca_metatag module.
 */
class MetatagHooks {

  /**
   * Constructs a new BaseHooks object.
   */
  public function __construct(
    protected TriggerEvent $triggerEvent,
  ) {}

  /**
   * Implements hook_metatags_alter().
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('metatags_alter')]
  public function metatagsAlter(array &$metatags, array &$context): void {
    $this->triggerEvent->dispatchFromPlugin('eca_metatag:alter', $metatags, $context);
  }

}
