(function ($, Drupal, drupalSettings, once) {

  Drupal.eca_form = {};

  Drupal.behaviors.eca_form = {
    attach: function (context, settings) {
        setTimeout(() => {
            once('ecaFormTemplate', 'form', context).forEach(($form) => {
                if ($($form).closest('.ui-dialog').length) {
                    return;
                }
                drupalSettings.eca_form.templates.forEach(($template) => {
                    let $select = $template['select'].split(':');
                    if ($select[0] === 'form') {
                        $select.shift();
                        if ($select[0] === 'field') {
                            let $fields;
                            if ($select[1] === 'type') {
                                if ($select[2] === 'select' || $select[2] === 'textarea') {
                                    $fields = $($select[2], $form);
                                }
                                else {
                                    $fields = $('input, select, textarea', $form).filter('[type="' + $select[2] + '"]');
                                }
                            } else if ($select[1] === 'required') {
                                if ($select[2] === 'yes') {
                                    $fields = $('input, select, textarea', $form).filter('[required]');
                                }
                                else {
                                    $fields = $('input, select, textarea', $form).not('[required]');
                                }
                            } else if ($select[1] === 'disabled') {
                                if ($select[2] === 'yes') {
                                    $fields = $('input, select, textarea', $form).filter('[disabled]');
                                }
                                else {
                                    $fields = $('input, select, textarea', $form).not('[disabled]');
                                }
                            } else if ($select[1] === 'all') {
                                $fields = $('input, select, textarea', $form);
                            }
                            $fields.each(function () {
                                if ($(this).attr('name') === 'ecatemplatedummy') {
                                    return;
                                }
                                let $fieldTemplate = {...$template};
                                $fieldTemplate['select'] = $(this).attr('name');
                                $fieldTemplate['applied_config'] = drupalSettings.eca.templates[$fieldTemplate['eca_id']]?.[$fieldTemplate['event_id']]?.[$fieldTemplate['select']];
                                Drupal.eca.addItemToSelectWidget(this, $fieldTemplate, Drupal.eca_form.config);
                            });
                        }
                    }
                });
            });
        }, 1000);
    },
  };

    Drupal.eca_form.config = function ($element, $template, $appliedConfig, $item) {
        let $config = $template['config']['form'];
        let $subform = $('<div class="eca-subform"></div>');
        let $parentForm = $($element).closest('form');
        let $availableFields = [];

        $parentForm.find('input, select, textarea').each( function () {
            if ($(this).attr('type') === 'hidden') {
                return;
            }
            let name = $(this).attr('name');
            if (name && !$availableFields.includes(name)) {
                $availableFields.push(name);
            }
        });
        $availableFields.sort(function (a, b) {
            return a.toLowerCase().localeCompare(b.toLowerCase());
        });

        if ($config) {
            if ($config.hasOwnProperty('field')) {
                Object.keys($config.field).forEach(function (key) {
                    let fieldNameInConfig = $config.field[key];
                    let $select = $('<select name="' + fieldNameInConfig + '" class="form-select"></select>');
                    $availableFields.forEach(function (fieldName) {
                        let $option = $('<option></option>').val(fieldName).text(fieldName);
                        if ($appliedConfig && $appliedConfig[fieldNameInConfig] === fieldName) {
                            $option.attr('selected', 'selected');
                        }
                        $select.append($option);
                    });
                    $subform.append('<div class="form-item"><label>' + key + '</label></div>');
                    $subform.find('.form-item:last').append($select);
                });
            }
            if ($config.hasOwnProperty('fields')) {
                Object.keys($config.fields).forEach(function (key) {
                    let fieldNameInConfig = $config.fields[key];
                    let $select = $('<select name="' + fieldNameInConfig + '" class="form-select" multiple="multiple" size="7"></select>');
                    $availableFields.forEach(function (fieldName) {
                        let $option = $('<option></option>').val(fieldName).text(fieldName);
                        if ($appliedConfig && Array.isArray($appliedConfig[fieldNameInConfig]) && $appliedConfig[fieldNameInConfig].includes(fieldName)) {
                            $option.attr('selected', 'selected');
                        }
                        $select.append($option);
                    });
                    $subform.append('<div class="form-item"><label>' + key + '</label></div>');
                    $subform.find('.form-item:last').append($select);
                });
            }
        }
        Drupal.eca.showTemplateConfigDialog($element, $template, $subform, $appliedConfig, $item);
    };

})(jQuery, Drupal, drupalSettings, once);
