(function ($, Drupal, drupalSettings, once) {

  Drupal.eca = {};

  Drupal.behaviors.eca = {
    attach: function (context, settings) {
      once('ecaTemplateActionButton', '.toolbar-button.eca-template-editing', context).forEach(($button) => {
        $($button).on('click', function (e) {
          e.preventDefault();
          Drupal.eca.toggleEditMode();
        });
      });
    },
  };

  Drupal.eca.toggleEditMode = function () {
    $('.toolbar-button.eca-template-editing').toggleClass('current');
    $('body').toggleClass('eca-template-editing');
  };

  /**
   * Add an item to a select widget in the DOM.
   *
   * By default, only a simple icon should be displayed and when clicked, a popup with all items should be opened for
   * selection. When an item gets selected, the given callback should be executed. The widget also requires a way to
   * be closed without selecting anything.
   *
   * @param $element
   *   The existing element in the DOM to which the widget should be added.
   * @param $template
   *   The selectable template.
   * @param $callback
   *   A callback to execute when this item is selected.
   */
  Drupal.eca.addItemToSelectWidget = function ($element, $template, $callback) {
    var $parent = $($element).closest('.form-item');
    var $container = $('.eca-select-widget-container', $parent);

    if ($container.length === 0) {
      $container = $('<div class="eca-select-widget-container"></div>');
      var $icon = $('<span class="eca-select-widget-icon" title="' + Drupal.t('Select item') + '"></span>');

      var $popup = $('<div class="eca-select-widget-popup"></div>');

      var $list = $('<ul></ul>');

      $popup.append($list);
      $container.append($icon).append($popup);
      $parent.prepend($container);

      $icon.on('click', function (e) {
        e.stopPropagation();
        $popup.toggle();
      });

      $(document).on('click', function () {
        $popup.hide();
      });

      $popup.on('click', function (e) {
        e.stopPropagation();
      });
    }

    var $popup = $container.find('.eca-select-widget-popup');
    var $list = $popup.find('ul');

    var $item = $('<li></li>')
      .attr('data-applied-config', JSON.stringify($template['applied_config']));
    
    var $itemContent = $('<span></span>').text($template['label']);
    $item.append($itemContent);
    
    // Add edit icon and applied indicator for applied templates
    if ($template.hasOwnProperty('applied_config') && $template['applied_config']) {
      $item.addClass('drupal-applied');
      
      // Check for corresponding modeler link and add edit icon if found
      if ($template.event_id && $template.eca_id) {
        var $modelerLink = $('a[data-modeler-eca-id="' + $template.eca_id + '"][data-modeler-eca-event-id="' + $template.event_id + '"]');
        if ($modelerLink.length > 0) {
          var $editIcon = $('<span class="eca-template-edit-icon" title="' + Drupal.t('Edit in modeler') + '">✎</span>');
          $editIcon.on('click', function (e) {
            e.stopPropagation();
            $modelerLink.get(0).click();
            $popup.hide();
          });
          $item.append($editIcon);
        }
      }
      
      var $appliedIndicator = $('<span class="eca-template-applied-indicator">✓</span>');
      $item.append($appliedIndicator);
    }
    
    $itemContent.on('click', function () {
      let appliedConfig = $item.attr('data-applied-config');
      if (typeof appliedConfig === 'string') {
        appliedConfig = JSON.parse(appliedConfig);
      }
      $callback($element, $template, appliedConfig, $item);
      $popup.hide();
    });

    var $items = $list.children('li');
    var inserted = false;
    for (var i = 0; i < $items.length; i++) {
      var $existingItem = $($items[i]);
      var existingLabel = $existingItem.find('span:first').text() || $existingItem.text();
      
      if (existingLabel.toLowerCase().localeCompare($template['label'].toLowerCase()) > 0) {
        $item.insertBefore($existingItem);
        inserted = true;
        break;
      }
    }
    if (!inserted) {
      $list.append($item);
    }
  };

  Drupal.eca.showTemplateConfigDialog = function ($element, $template, $subform, $appliedConfig, $item) {
    let $config = $template['config']['global'];
    let $form = $('<form class="eca-form-template-config-form"></form>');
    $form.append($subform);
    if ($config && $config.hasOwnProperty('value')) {
      Object.keys($config.value).forEach( function (key) {
        let fieldNameInConfig = $config.value[key];
        let defaultValue = ($appliedConfig && $appliedConfig.hasOwnProperty(fieldNameInConfig)) ? $appliedConfig[fieldNameInConfig] : '';
        $form.append('<div class="form-item"><label>' + key + '</label><input type="text" name="' + fieldNameInConfig + '" class="form-text" value="' + defaultValue + '"></div>');
      });
    }


    $form.append('<div class="form-actions"><input type="submit" value="' + Drupal.t('Submit') + '" class="button button--primary"></div>');

    let $dialog = $('<div></div>').append($form).appendTo('body');
    let dialog = Drupal.dialog($dialog, {
      title: $template.label || Drupal.t('Configure template'),
      dialogClass: 'eca-form-template-config-dialog',
      close: function () {
        $dialog.remove();
      }
    });

    $form.on('submit', function (e) {
      e.preventDefault();
      let data = $template['config']['hidden'] || {};
      $form.find('input, select, textarea').each( function () {
        let name = $(this).attr('name');
        if (!name) {
          return;
        }
        data[name] = $(this).val();
      });
      dialog.close();
      Drupal.eca.applyTemplate($element, $template, data, $item);
    });

    dialog.showModal();
  };

  Drupal.eca.applyTemplate = async function ($element, $template, data, $item) {
    if ($item) {
      $item.addClass('drupal-applied').attr('data-applied-config', JSON.stringify(data));
    }
    Drupal.eca.toggleEditMode();
    let response = await fetch(drupalSettings.eca_ng.token_url);
    if (response.ok) {
      let token = await response.text();
      $(document).one('ajaxComplete', function handleAjaxComplete() {
        $('[name="ecatemplatedummy"]').trigger('eca-ajax-reload');
      });
      let request = Drupal.ajax({
        url: drupalSettings.eca_ng.template_apply_url,
        submit: JSON.stringify([$template.template_id, $template.event_id, $template.eca_id, $template.select, data]),
        beforeSend: function (xhr) {
          xhr.overrideMimeType("application/json;charset=UTF-8");
          xhr.setRequestHeader("X-CSRF-Token", token);
        },
        progress: {
          type: 'fullscreen',
          message: Drupal.t('Applying template...'),
        },
      });
      request.execute();
    }
  };

})(jQuery, Drupal, drupalSettings, once);
