<?php

namespace Drupal\eca_ng\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Url;
use Drupal\eca\Processor;

/**
 * Implements library hooks for the ECA module.
 */
class LibraryHooks {

  /**
   * Implements hook_library_info_alter().
   */
  #[Hook('library_info_alter')]
  public function libraryInfoAlter(array &$libraries, string $extension): void {
    if ($extension === 'eca_ng' && isset($libraries['templates'])) {
      $libraries['templates']['drupalSettings']['eca_ng']['token_url'] = Url::fromRoute('system.csrftoken')->toString();
      $libraries['templates']['drupalSettings']['eca_ng']['template_apply_url'] = Url::fromRoute('eca_ng.template.apply')->toString();
    }
  }

  /**
   * Implements hook_page_attachments().
   */
  #[Hook('page_attachments')]
  public function pageBuildAlter(array &$attachments): void {
    $attachments['#attached']['drupalSettings']['eca']['templates'] = Processor::getAppliedTemplates();
  }

}
