<?php

namespace Drupal\eca_ng\Service;

/**
 * Service class for ECA templates.
 */
class Template {

  /**
   * Flag whether template editing is enabled.
   *
   * @var bool
   */
  protected bool $editingEnabled = FALSE;

  /**
   * Returns whether template editing is enabled.
   *
   * @return bool
   *   TRUE if template editing is enabled, FALSE otherwise.
   */
  public function isEditingEnabled(): bool {
    return $this->editingEnabled;
  }

  /**
   * Enables template editing.
   */
  public function enableEditing(): void {
    $this->editingEnabled = TRUE;
  }

}
