<?php

namespace Drupal\eca_views_data_export\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\eca\Event\TriggerEvent;
use Drupal\eca\Hook\TokenHooks as EcaTokenHooks;
use Psr\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface as SymfonyEventDispatcherInterface;

/**
 * Implements token hooks for the eca_views_data_export module.
 */
class TokenHooks {

  use StringTranslationTrait;

  /**
   * Constructs a new BaseHooks object.
   */
  public function __construct(
    protected TriggerEvent $triggerEvent,
    protected EventDispatcherInterface $eventDispatcher,
  ) {}

  /**
   * Implements hook_token_info().
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('token_info')]
  public function tokenInfo(): array {
    $info = [];
    $info['types']['current_result'] = [
      'name' => $this->t('Current views result'),
      'needs-data' => 'current_result',
      'nested' => TRUE,
      'dynamic' => TRUE,
    ];
    $info['types']['current_row'] = [
      'name' => $this->t('Current views row'),
      'needs-data' => 'current_row',
      'nested' => TRUE,
      'dynamic' => TRUE,
    ];
    $info['tokens']['current_result']['dummy'] = [
      'name' => $this->t('Just a dummy'),
    ];
    $info['tokens']['current_row']['dummy'] = [
      'name' => $this->t('Just a dummy'),
    ];
    return $info;
  }

  /**
   * Implements hook_tokens().
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('tokens')]
  public function tokens(string $type, array $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata): array {
    if ($type === 'current_result' && !empty($data['current_result'])) {
      $data['dto'] = $data['current_result'];
      unset($data['current_result']);
      if (function_exists('eca_tokens')) {
        return eca_tokens('dto', $tokens, $data, $options, $bubbleable_metadata);
      }
      if ($this->eventDispatcher instanceof SymfonyEventDispatcherInterface) {
        foreach ($this->eventDispatcher->getListeners('drupal_hook.tokens') as $listener) {
          if ($listener[0] instanceof EcaTokenHooks) {
            return call_user_func($listener, 'dto', $tokens, $data, $options, $bubbleable_metadata);
          }
        }
      }
    }
    if ($type === 'current_row' && !empty($data['current_row'])) {
      $data['dto'] = $data['current_row'];
      unset($data['current_row']);
      if (function_exists('eca_tokens')) {
        return eca_tokens('dto', $tokens, $data, $options, $bubbleable_metadata);
      }
      if ($this->eventDispatcher instanceof SymfonyEventDispatcherInterface) {
        foreach ($this->eventDispatcher->getListeners('drupal_hook.tokens') as $listener) {
          if ($listener[0] instanceof EcaTokenHooks) {
            return call_user_func($listener, 'dto', $tokens, $data, $options, $bubbleable_metadata);
          }
        }
      }
    }
    return [];
  }

}
