<?php

namespace Drupal\eca_views_data_export\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\eca\Event\TriggerEvent;
use Drupal\views\ResultRow;
use Drupal\views\ViewExecutable;

/**
 * Implements views hooks for the eca_views_data_export module.
 */
class ViewsHooks {

  /**
   * Constructs a new BaseHooks object.
   */
  public function __construct(
    protected TriggerEvent $triggerEvent,
  ) {}

  /**
   * Implements hook_views_data_export_row_alter().
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('views_data_export_row_alter')]
  public function viewsDataExportRowAlter(array &$row, ResultRow $result, ViewExecutable $view): void {
    $this->triggerEvent->dispatchFromPlugin('eca_views_data_export:alter_row', $row, $result, $view);
  }

}
