# ECA: Zoom

This module allows you to automate Zoom Meetings operations within Drupal ECA models.
Create, manage, and analyze Zoom meetings, webinars, and participants using ECA's visual workflow builder.

## Features

### Complete Meeting and Webinar Management:
- **Create Meetings/Webinars**: Schedule new Zoom meetings or webinars with custom settings
- **Update Meetings/Webinars**: Modify existing meetings/webinars including times, settings, and participants
- **Delete Meetings/Webinars**: Cancel scheduled meetings/webinars with participant notifications
- **Get Meeting/Webinar**: Retrieve detailed information and settings
- **List Meetings/Webinars**: Query user's meetings/webinars with type filtering and pagination

### Registrant Management:
- **Add Registrant**: Register users for meetings and webinars
- **Remove Registrant**: Unregister registrants from meetings and webinars
- **List Registrants**: View registered participants with status filtering (approved/pending/denied)

### Post-Meeting/Webinar Analytics:
- **Get Meeting/Webinar Report**: Access detailed analytics including participant data and engagement metrics
- **Get Recording Details**: Retrieve recording metadata with download URLs and file information
- **Get Participant Report**: Individual participant engagement and activity data with pagination

### Resource Type Selector:
- **Unified Actions**: All actions support both meetings and webinars via resource type selector
- **Dynamic Selection**: Choose "Meeting", "Webinar", or "From Token" for runtime determination
- **Consistent Interface**: Same actions and settings for both resource types

### Advanced Capabilities:
- **URL Support**: Accept both meeting IDs and full Zoom URLs with automatic ID extraction
- **Flexible Settings**: YAML-based additional settings for complete API access
- **DateTime Handling**: Support for multiple datetime formats with timezone conversion
- **Token Integration**: Full ECA token support for dynamic values
- **Pagination**: Built-in support for handling large result sets

### Available Actions

**Zoom: Get Meeting**
- Retrieve complete meeting/webinar details and current settings
- Essential for fetch-merge-update workflows to preserve existing settings
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Create Meeting**
- Schedule new meetings or webinars with topic, time, duration, and timezone
- YAML-based additional settings for passwords, waiting rooms, recording options, and more
- Support for instant meetings, scheduled meetings, and webinars
- Resource type selector determines meeting type (1/2) or webinar type (5)

**Zoom: Update Meeting**
- Modify existing meeting/webinar details and settings
- Partial updates preserve unspecified fields
- Combine with Get Meeting action for safe updates
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Delete Meeting**
- Cancel scheduled meetings/webinars with optional participant notifications
- Configurable cancellation reason messages
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: List User Meetings**
- Query meetings/webinars by type: scheduled, live, upcoming, or previous
- Pagination support for large lists
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Add Meeting Registrant**
- Register users for meetings/webinars with email, name, and custom registration questions
- Support for auto-approval settings and custom fields
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Remove Meeting Registrant**
- Unregister registrants from meetings/webinars using registrant ID
- Works with registration-based meetings/webinars
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: List Meeting Registrants**
- View all registered participants for meetings/webinars with status filtering
- Filter by approved, pending, or denied status
- Pagination support for large registrant lists
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Get Meeting Report**
- Detailed post-meeting/webinar analytics and participant data
- Access duration, join/leave times, and engagement metrics
- Requires meeting UUID for past meetings/webinars
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Get Recording Details**
- Access recording metadata with download URLs for meetings/webinars
- Multiple file formats: MP4, M4A, transcript, and chat
- File sizes and sharing settings included
- Resource type selector: Meeting, Webinar, or From Token

**Zoom: Get Participant Report**
- Individual participant engagement and session details for meetings/webinars
- Attendance tracking and interaction history
- Pagination for meetings/webinars with many participants
- Resource type selector: Meeting, Webinar, or From Token

### Meeting/Webinar ID and URL Support
All actions accept both formats for meeting/webinar identification:
- **Meeting/Webinar ID**: `1234567890`
- **Full URL**: `https://zoom.us/j/1234567890`

The module automatically extracts the ID from URLs for seamless workflow integration.

### DateTime Handling
Flexible datetime input support:
- **Token Integration**: Use field tokens like `[entity:field_date:value]`
- **Multiple Formats**: ISO 8601, timestamps, natural language strings
- **Timezone Conversion**: Automatic conversion with Drupal's default timezone fallback
- **Smart Defaults**: Empty timezone uses your Drupal site's configured timezone

### YAML Additional Settings
For maximum flexibility, most actions support YAML-based additional settings:

**Meeting Settings Example:**
```yaml
password: "secret123"
alternative_hosts: "user@example.com"
settings:
  waiting_room: true
  host_video: true
  participant_video: false
  mute_upon_entry: true
  auto_recording: "cloud"
recurrence:
  type: 2
  repeat_interval: 1
  weekly_days: "1,3,5"
  end_times: 10
```

**Webinar Settings Example:**
```yaml
type: 5
agenda: "Quarterly Product Update"
settings:
  hd_video: true
  approval_type: 0
  registration_type: 1
  panelists_video: true
  practice_session: true
  question_answer:
    enable: true
    allow_anonymous_questions: false
```

See the [Zoom API documentation](https://developers.zoom.us/docs/api/) for all available options.

## Additional Requirements

**Required Drupal Modules:**
- **ECA** - Event Condition Action workflow system
- **Zoom API** - Zoom service authentication and API client

**Zoom Requirements:**
- Zoom account (Pro, Business, or Enterprise for most features)
- Server-to-Server OAuth app configured in Zoom Marketplace
- Account ID, Client ID, and Client Secret from your Zoom app

**API Configuration:**
Configure your Zoom API credentials in the Zoom API module settings before using ECA: Zoom actions.

## Authentication

**Server-to-Server OAuth:**
- Account-level access without user interaction
- Configured once in Zoom API module settings
- All ECA actions use the same credentials automatically
- Suitable for automated workflows and system integration

## Use Cases

**Event Management:**
- Automatically create Zoom meetings when Drupal events are published
- Include meeting links in event confirmations and reminder emails
- Cancel meetings when events are deleted or postponed

**Registration Workflows:**
- Register webinar registrants from form submissions
- Sync registrant lists with Drupal user registrations
- Send custom confirmation emails with join links

**Training and Education:**
- Schedule recurring training sessions automatically
- Track attendance through participant reports
- Archive recordings and transcripts for course materials

**Meeting Analytics:**
- Generate attendance reports from completed meetings
- Track participant engagement metrics
- Download recordings for content processing

**Customer Support:**
- Create support meetings on-demand from ticket systems
- Add customers as registrants automatically
- Track meeting history in customer records

**Workflow Integration Examples:**

**Automated Meeting/Webinar Creation:**
1. User submits event registration form
2. ECA creates Zoom meeting or webinar with form data (resource type selector)
3. Meeting/webinar details stored in token
4. User receives confirmation email with join link

**Safe Meeting/Webinar Updates:**
1. Get Meeting action retrieves current settings (specify resource type)
2. ECA modifies specific fields in token data
3. Update Meeting action applies changes (specify resource type)
4. Other settings remain unchanged

**Post-Meeting/Webinar Processing:**
1. Meeting/webinar ends (scheduled task or webhook trigger)
2. Get Meeting Report retrieves attendance data (specify resource type)
3. Get Recording Details fetches recording URLs (specify resource type)
4. Custom processing workflows archive content

**Webinar Registration:**
1. User completes webinar registration form
2. Add Registrant action registers them in Zoom (resource type: Webinar)
3. Registration confirmation sent via email
4. List Registrants tracks total registrations (resource type: Webinar)

## Important Notes

**Resource Type Selector:**
All actions include a Resource Type field with three options:
- **Meeting** (default): Work with Zoom meetings
- **Webinar**: Work with Zoom webinars
- **From Token**: Determine resource type dynamically at runtime from a token value

**Meeting/Webinar Settings:**
When updating meetings or webinars, use the Get Meeting action first to retrieve current settings, then modify specific values in your workflow before calling Update Meeting. This ensures you don't inadvertently clear settings you didn't intend to change.

**Timezone Handling:**
If no timezone is specified, the module uses your Drupal site's default timezone. This is especially important when using date fields that don't include timezone information.

**Pagination:**
Actions that return lists (List Meetings, List Registrants, Get Participant Report) include a `next_page_token` in their response. Use this token in subsequent requests to retrieve additional pages of results.

**Recording Availability:**
Recordings may not be immediately available after a meeting ends. Zoom processes recordings asynchronously, which can take several minutes to hours depending on meeting length.

**API Rate Limits:**
Zoom enforces rate limits on API requests. For high-volume operations, implement appropriate delays or error handling in your workflows.
