<?php

namespace Drupal\ecoindex\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Drupal\Core\Session\AccountSwitcherInterface;
use Drupal\user\Entity\User;

/**
 * Event subscriber to switch user to anonymous for preview route.
 */
class PreviewUserSwitchSubscriber implements EventSubscriberInterface {

  /**
   * @var \Drupal\Core\Session\AccountSwitcherInterface
   */
  protected $accountSwitcher;

  /**
   * Flag is account is switch.
   *
   * @var bool
   */
  protected $switched = FALSE;

  public function __construct(AccountSwitcherInterface $account_switcher) {
    $this->accountSwitcher = $account_switcher;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::REQUEST => ['onRequest', 20],
      KernelEvents::RESPONSE => ['onResponse', 0],
    ];
  }

  /**
   * Switch user to anonymous for preview route before controller executes.
   */
  public function onRequest(RequestEvent $event) {
    $route_name = $event->getRequest()->attributes->get('_route');
    if ($route_name === 'ecoindex.preview') {
      $this->accountSwitcher->switchTo(User::getAnonymousUser());
      $this->switched = TRUE;
    }
  }

  /**
   * Switch back to original user after response is built.
   */
  public function onResponse(ResponseEvent $event) {
    if ($this->switched) {
      $this->accountSwitcher->switchBack();
      $this->switched = FALSE;
    }
  }
}
