((Drupal, drupalSettings) => {
  // Get nid.
  const nid = drupalSettings.ecoindex.nid;

  // Get EcoIndex field_name.
  const field = drupalSettings.ecoindex.field;

  // Get Current langcode.
  const language = drupalSettings.path.currentLanguage;

  // Get score and save it.
  const score = localStorage.getItem(`ecoindex.score.${language}.${nid}`);
  if (score) {
    const scoreElement = document.getElementById(
      `edit-${field.replaceAll('_', '-')}-0-score`,
    );
    const originalScore = scoreElement.value;
    scoreElement.value = score;
    if (originalScore !== score) {
      addWarningDescription(scoreElement, 'Score');
    } else {
      scoreElement.disabled = true;
    }
  }

  // Get grade and save it.
  const grade = localStorage.getItem(`ecoindex.grade.${language}.${nid}`);
  if (grade) {
    const gradeElement = document.getElementById(
      `edit-${field.replaceAll('_', '-')}-0-grade`,
    );
    const originalGrade = gradeElement.value;
    gradeElement.value = grade;
    if (originalGrade !== grade) {
      addWarningDescription(gradeElement, 'Grade');
    } else {
      gradeElement.disabled = true;
    }
  }

  // Get elementCount and save it.
  const elementCount = localStorage.getItem(
    `ecoindex.elementCount.${language}.${nid}`,
  );
  if (elementCount) {
    const elementCountElement = document.getElementById(
      `edit-${field.replaceAll('_', '-')}-0-element-count`,
    );
    const originalElementCount = elementCountElement.value;
    elementCountElement.value = elementCount;
    if (originalElementCount !== elementCount) {
      addWarningDescription(elementCountElement, 'Element Count');
    } else {
      elementCountElement.disabled = true;
    }
  }

  // Get requestCount and save it.
  const requestCount = localStorage.getItem(
    `ecoindex.requestCount.${language}.${nid}`,
  );
  if (requestCount) {
    const requestCountElement = document.getElementById(
      `edit-${field.replaceAll('_', '-')}-0-request-count`,
    );
    const originalRequestCount = requestCountElement.value;
    requestCountElement.value = requestCount;
    if (originalRequestCount !== requestCount) {
      addWarningDescription(requestCountElement, 'Request Count');
    } else {
      requestCountElement.disabled = true;
    }
  }

  // Get totalSizeKB and save it.
  const totalSizeKB = localStorage.getItem(
    `ecoindex.totalSizeKB.${language}.${nid}`,
  );
  if (totalSizeKB) {
    const totalSizeKBElement = document.getElementById(
      `edit-${field.replaceAll('_', '-')}-0-total-size-kb`,
    );
    const originalTotalSizeKB = totalSizeKBElement.value;
    const parsedTotalSizeKB = parseInt(totalSizeKB, 10);
    totalSizeKBElement.value = parsedTotalSizeKB;
    if (originalTotalSizeKB !== parsedTotalSizeKB.toString()) {
      addWarningDescription(totalSizeKBElement, 'Total Size (KB)');
    } else {
      totalSizeKBElement.disabled = true;
    }
  }

  /**
   * Adds a warning description below a form element.
   *
   * @param {HTMLElement} element - The form element to add description to.
   * @param {string} fieldName - The name of the field for the description.
   */
  function addWarningDescription(element, fieldName) {
    const warningDiv = document.createElement('div');
    warningDiv.className = 'description';
    warningDiv.innerHTML = `⚠️ ${fieldName} has been updated. Please save the form to persist the changes.`;
    warningDiv.style.color = '#856404';
    warningDiv.style.fontSize = '0.875rem';
    warningDiv.style.marginTop = '0.25rem';

    // Insert the warning after the element
    element.parentNode.insertBefore(warningDiv, element.nextSibling);
  }
})(Drupal, drupalSettings);
