<?php

namespace Drupal\ecoindex\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'ecoindex' field type.
 *
 * @FieldType(
 *   id = "ecoindex",
 *   label = @Translation("EcoIndex"),
 *   module = "ecoindex",
 *   description = @Translation("Store EcoIndex score and grade value."),
 *   default_widget = "ecoindex_widget",
 *   default_formatter = "ecoindex_score_formatter",
 *   constraints = {"EcoIndexField" = {}}
 * )
 */
class EcoIndexItem extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['score'] = DataDefinition::create('integer')
      ->setLabel(new TranslatableMarkup('EcoIndex score'));

    $properties['grade'] = DataDefinition::create('string')
      ->setLabel(new TranslatableMarkup('EcoIndex grade'));

    $properties['element_count'] = DataDefinition::create('integer')
      ->setLabel(new TranslatableMarkup('Element count'));

    $properties['request_count'] = DataDefinition::create('integer')
      ->setLabel(new TranslatableMarkup('Request count'));

    $properties['total_size_kb'] = DataDefinition::create('float')
      ->setLabel(new TranslatableMarkup('Total size (KB)'));

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'score' => [
          'description' => 'EcoIndex score.',
          'type' => 'int',
          'size' => 'tiny',
        ],
        'grade' => [
          'description' => 'EcoIndex grade.',
          'type' => 'varchar',
          'length' => 1,
        ],
        'element_count' => [
          'description' => 'Number of elements.',
          'type' => 'int',
          'size' => 'normal',
        ],
        'request_count' => [
          'description' => 'Number of requests.',
          'type' => 'int',
          'size' => 'normal',
        ],
        'total_size_kb' => [
          'description' => 'Total size in KB.',
          'type' => 'float',
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function mainPropertyName() {
    return 'score';
  }

}
