<?php

namespace Drupal\Tests\ecoindex\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\entity_test\Entity\EntityTest;

/**
 * Tests the EcoIndex field type.
 *
 * @group ecoindex
 */
class EcoIndexFieldTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'ecoindex',
    'field',
    'entity_test',
    'user',
    'system',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('entity_test');
    $this->installEntitySchema('user');
    $this->installConfig(['field', 'system']);
  }

  /**
   * Tests the EcoIndex field type.
   */
  public function testEcoIndexField() {
    // Create a field storage.
    $field_storage = FieldStorageConfig::create([
      'field_name' => 'test_ecoindex',
      'entity_type' => 'entity_test',
      'type' => 'ecoindex',
    ]);
    $field_storage->save();

    // Create a field instance.
    $field = FieldConfig::create([
      'field_name' => 'test_ecoindex',
      'entity_type' => 'entity_test',
      'bundle' => 'entity_test',
      'label' => 'Test EcoIndex',
    ]);
    $field->save();

    // Create an entity with the field.
    $entity = EntityTest::create([
      'name' => 'Test entity',
    ]);
    $entity->test_ecoindex->score = 75;
    $entity->test_ecoindex->grade = 'B';
    $entity->test_ecoindex->element_count = 100;
    $entity->test_ecoindex->request_count = 20;
    $entity->test_ecoindex->total_size_kb = 150.5;
    $entity->save();

    // Load the entity and verify the values.
    $entity = EntityTest::load($entity->id());
    $this->assertEquals(75, $entity->test_ecoindex->score);
    $this->assertEquals('B', $entity->test_ecoindex->grade);
    $this->assertEquals(100, $entity->test_ecoindex->element_count);
    $this->assertEquals(20, $entity->test_ecoindex->request_count);
    $this->assertEquals(150.5, $entity->test_ecoindex->total_size_kb);
  }

}
