<?php

namespace Drupal\edit_own_user_account_permission\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Edit Own User Account Access Check permissions class.
 */
class EditOwnUserAccountAccessCheck implements AccessInterface {

  /**
   * {@inheritdoc}
   */
  public function access(AccountInterface $user, AccountInterface $account) {
    $can_edit_own_account = ($account->hasPermission('edit own user account') && $user->id() == $account->id());
    return AccessResult::allowedIf($can_edit_own_account || $account->hasPermission('administer users'));
  }

}
