export const registerChangeIndicators = () => {

  /**
   * Registers the Change indicator configuration with the Navigation+ tool indicators manager.
   */
  if (typeof window.registerToolIndicatorConfig === 'function') {
    const changeIndicators = [
      {
        type: 'field',
        icon: drupalSettings.navigationPlus.toolIndicators.icons['edit_plus'] ?? null,
        handlers: {
          onClick: (e) => {
            e.preventDefault();
            const fieldIndicator = e.target.closest('.field-indicator');
            fieldIndicator.classList.add('disabled');
            const editableField = e.target.closest('[data-edit-plus-field-value-wrapper]').querySelector('.edit-plus-field-value');
            Drupal.EditPlus.EditableElementClicked(editableField);
          },
        },
      },
    ];

    window.registerToolIndicatorConfig('edit_plus', changeIndicators);
  }
};
