<?php

namespace Drupal\edit_plus\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\navigation_plus\Event\EditableFieldAttributes;

/**
 * No change tool event.
 */
class NoChangeTool extends Event {

  protected $noChangeTool = FALSE;

  public function __construct(
    protected EditableFieldAttributes $editableFieldAttributes,
  ) {}

  public function setNoChangeTool() {
    $this->noChangeTool = TRUE;
  }

  public function noChangeTool(): bool {
    return $this->noChangeTool;
  }

  /**
   * @return \Drupal\navigation_plus\Event\EditableFieldAttributes
   */
  public function getEditableFieldAttributes(): EditableFieldAttributes {
    return $this->editableFieldAttributes;
  }

}
