<?php

namespace Drupal\edit_plus;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\edit_plus\Form\LayoutBuilderBlockFormAlter;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

class EditPlusServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $modules = $container->getParameter('container.modules');
    if (isset($modules['lb_plus'])) {
      $container->register('edit_plus.form_alter.lb_block', LayoutBuilderBlockFormAlter::class)
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE);
    }
  }

}
