import * as entityForm from '../entity-form.js';
import * as fieldPluginBase from './field-plugin-base.js';

export default function ($ = jQuery, Drupal, once, dropZones) {

  /**
   * Media field plugin.
   */
  class MediaPlugin extends fieldPluginBase.FieldPluginBase {
    constructor() {
      super();
      this.originalValue = null;
    }
    supportedWidgets = [
      'media_library_widget',
    ];
    focusElement(EditableElement) {
      this.originalValue = this.getMediaWidgetValue(EditableElement);
      window.setFileDrag(false);
    }
    blurElement(EditableElement) {
      const newValue = this.getMediaWidgetValue(EditableElement)

      this.replaceFormItemWithPageElement(EditableElement);
      if (this.originalValue !== newValue) {
        entityForm.updateTempstore(EditableElement, newValue === null);
      }
      window.setFileDrag(true);
      return Promise.resolve();
    }

    getFocusedSelectors() {
      let selectors = super.getFocusedSelectors();
      selectors.push('.field--widget-media-library-widget', '#drupal-modal', '.ui-dialog-buttonpane');
      return selectors;
    }

    validationMessageHandle() {
      const EditableElement = Drupal.EditPlus.CurrentlyEditingElement;
      return EditableElement.getFormItem().querySelector('.fieldset-wrapper');
    }

    isValid(e = null) {
      const EditableElement = Drupal.EditPlus.CurrentlyEditingElement;
      if (!EditableElement.getFormItem().hasAttribute('required')) {
        return true;
      }
      const newValue = this.getMediaWidgetValue(EditableElement);
      const isValid = newValue !== null;
      if (!isValid) {
        this.displayValidationMessage(Drupal.t('A media item is required.'));
      }
      return isValid;
    }

    getMediaWidgetValue(EditableElement) {
      return EditableElement.getFormItemWrapper().querySelector('.edit-plus-field-value [src]')?.src ?? null;
    }

    clearValidationMessageOnUserInput (validationMessageHandle) {
      // Do nothing. The validation message is removed when the media library
      // is used.
    }

  }

  /**
   * Register the default field plugin.
   */
  window.addEventListener('EditPlusFieldManager.RegisterPlugins', e => {
    e.detail.manager.registerPlugin(new MediaPlugin());
  });

}

