<?php

namespace Drupal\edit_plus_lb;

use Symfony\Component\DependencyInjection\Reference;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Defines a service provider for the LB Plus Edit Plus module.
 */
class EditPlusLbServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('edit_plus.tempstore_repository')) {
      $definition = $container->getDefinition('edit_plus.tempstore_repository');

      // Get the tempstore factory from the original service definition.
      $tempstore_factory = $definition->getArgument(0);

      // Build the complete argument list in the correct order.
      $arguments = [
        $tempstore_factory,
        new Reference('layout_builder.tempstore_repository'),
        new Reference('plugin.manager.layout_builder.section_storage'),
      ];

      // Add workspace manager as 4th argument if workspaces module is enabled.
      if ($container->hasDefinition('workspaces.manager')) {
        $arguments[] = new Reference('workspaces.manager');
      }

      $definition->setClass(EditPlusLbTempstoreRepository::class)
        ->setArguments($arguments);
    }
  }

}
