<?php

namespace Drupal\edit_plus;

use Symfony\Component\DependencyInjection\Reference;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\edit_plus\Form\LayoutBuilderBlockFormAlter;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

class EditPlusServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $modules = $container->getParameter('container.modules');
    if (isset($modules['lb_plus'])) {
      $container->register('edit_plus.form_alter.lb_block', LayoutBuilderBlockFormAlter::class)
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE);
    }

    // This allows Edit Plus to be workspace-aware when workspaces are available
    // but still function without the workspaces module.
    if ($container->hasDefinition('workspaces.manager')) {
      $definition = $container->getDefinition('edit_plus.tempstore_repository');
      $arguments = $definition->getArguments();
      $arguments[] = new Reference('workspaces.manager');
      $definition->setArguments($arguments);
    }
  }

}
