(($, Drupal, once, window) => {

  /**
   * Hotkeys behavior
   *
   * This is a conditional behavior based on the Change tool (edit_plus tool) being active.
   */
  const EditPlusHotkeys = {
    ckeditorFocusStates: new Map(),

    attach(context, settings) {
      once('edit-plus-hotkeys-enabled', 'html').forEach(page => {
        document.addEventListener('keyup', this.onKeyUp);
      });
    },

    detach(context, settings) {
      once.remove('edit-plus-hotkeys-enabled', 'html');
      document.removeEventListener('keyup', this.onKeyUp);
    },

    onKeyUp(e) {
      if (e.key === 'Escape' && Drupal.EditPlus.CurrentlyEditingElement) {
        const EditableElement = Drupal.EditPlus.CurrentlyEditingElement;
        EditableElement.plugin.cancelEdit(EditableElement, e);
      }
    },
  };

  /**
   * Register and attach
   */
  window.listenToStateChange(
    state => state.tool.currentTool,
    currentTool => {
      if (currentTool === 'edit_plus') {
        Drupal.behaviors.EditPlusHotkeys = EditPlusHotkeys;
        Drupal.behaviors.EditPlusHotkeys.attach(document, drupalSettings);
      } else if (currentTool !== 'edit_plus' && Drupal.behaviors.EditPlusHotkeys) {
        Drupal.behaviors.EditPlusHotkeys.detach(document, drupalSettings);
        delete Drupal.behaviors.EditPlusHotkeys;
      }
    },
  );

})(jQuery, Drupal, once, window);

