<?php

declare(strict_types=1);

namespace Drupal\edit_plus\EventSubscriber;

use Drupal\edit_plus\Event\NoChangeTool as NoChangeToolEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class NoChangeTool implements EventSubscriberInterface {

  protected $ignoreViewModes = [
    'media_library',
  ];

  public function onNoChangeTool(NoChangeToolEvent $event) {
    $variables = $event->getEditableFieldAttributes()->getVariables();
    $element = &$variables['element'];
    $view_mode = $element['#view_mode'];
    if (in_array($view_mode, $this->ignoreViewModes, TRUE)) {
      $event->setNoChangeTool();
      $event->stopPropagation();
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      NoChangeToolEvent::class => ['onNoChangeTool'],
    ];
  }

}
