<?php

namespace Drupal\edit_plus\EventSubscriber;

use Drupal\edit_plus\EditPlusFormTrait;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Navigation+ replace media.
 */
class NavigationPlusReplaceMediaClearForm implements EventSubscriberInterface {

  use EditPlusFormTrait;

  public function __construct(
    protected RequestStack $requestStack,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = [];
    if (class_exists(\Drupal\navigation_plus\Event\LayoutBuilderReplaceMedia::class)) {
      $events[\Drupal\navigation_plus\Event\LayoutBuilderReplaceMedia::class] = ['onReplace', -100];
    }
    return $events;
  }

  /**
   * On replace.
   *
   * A user has dragged a Media Type compatible file from their desktop to a
   * dropzone on an existing Media Block on the page. NavigationPlusReplaceMedia
   * has replaced the media, lets remove the now stale media form if it exists.
   *
   * @param \Drupal\navigation_plus\Event\LayoutBuilderReplaceMedia $event
   *
   * @return void
   */
  public function onReplace(\Drupal\navigation_plus\Event\LayoutBuilderReplaceMedia $event) {
    $media_block = $event->getMediaBlock();
    $response = $event->getResponse();
    $this->clearForm($response, $media_block);
    $event->setResponse($response);
  }

  public function entityContent(array &$form, FormStateInterface $form_state, string $view_mode = NULL) {
    // Satisfy EditPlusFormTrait...
    // @todo Move the ajax methods out of the form trait since they can be used
    // outside of a form.
  }

}
