<?php

namespace Drupal\edit_plus;

use Symfony\Component\DependencyInjection\Reference;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\edit_plus\Form\LayoutBuilderBlockFormAlter;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

class EditPlusServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $modules = $container->getParameter('container.modules');
    if (isset($modules['lb_plus'])) {
      $container->register('edit_plus.form_alter.lb_block', LayoutBuilderBlockFormAlter::class)
        ->setAutoconfigured(TRUE)
        ->setAutowired(TRUE);
    }

    // Register backward compatibility alias only if tempstore_plus is available.
    if ($container->hasDefinition('tempstore_plus.entity_tempstore_repository')) {
      $container->setAlias('edit_plus.tempstore_repository', 'tempstore_plus.entity_tempstore_repository');
    }
  }

}
