<?php

namespace Drupal\edit_plus_cta_block\EventSubscriber;

use Drupal\lb_plus\Event\PlaceBlockEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Teaser.
 *
 * An example of how to alter the Inline Block form to be able to change classes
 * on the block for styling.
 */
class CtaBlockProperties implements EventSubscriberInterface {

  /**
   * On post place block form build.
   *
   * @param \Drupal\lb_plus\Event\PlaceBlockEvent $event
   *  Dispatched after the blocks content has been auto-generated.
   *
   * @return void
   */
  public function onPrePlaceBlockFormBuild(PlaceBlockEvent $event) {
    if ($event->getBlockPluginId() === 'inline_block' && $event->getBundle() === 'call_to_action') {
      $block_plugin = $event->getBlockPlugin();
      $configuration = $block_plugin->getConfiguration();
      $configuration['label_display'] = 'visible';
      $configuration['label'] = $block_plugin->label();
      $block_plugin->setConfiguration($configuration);
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      PlaceBlockEvent::class => ['onPrePlaceBlockFormBuild'],
    ];
  }

}
